/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.mime.content.AbstractContentBody;

public class FileBody
extends AbstractContentBody {
    private final File file;
    private final String filename;
    private final String charset;

    public FileBody(File file2, String filename2, String mimeType, String charset) {
        super(mimeType);
        if (file2 == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        this.file = file2;
        this.filename = filename2 != null ? filename2 : file2.getName();
        this.charset = charset;
    }

    public FileBody(File file2, String mimeType, String charset) {
        this(file2, null, mimeType, charset);
    }

    public FileBody(File file2, String mimeType) {
        this(file2, mimeType, null);
    }

    public FileBody(File file2) {
        this(file2, "application/octet-stream");
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Deprecated
    public void writeTo(OutputStream out, int mode2) throws IOException {
        this.writeTo(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream in = new FileInputStream(this.file);
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = ((InputStream)in).read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public String getCharset() {
        return this.charset;
    }

    public long getContentLength() {
        return this.file.length();
    }

    public String getFilename() {
        return this.filename;
    }

    public File getFile() {
        return this.file;
    }
}

