/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.cache.InputLimit;
import org.apache.http.client.cache.Resource;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.impl.client.cache.HeapResource;
import org.apache.http.impl.client.cache.IOUtils;

@Immutable
public class HeapResourceFactory
implements ResourceFactory {
    public Resource generate(String requestId, InputStream instream, InputLimit limit2) throws IOException {
        int l;
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        long total2 = 0L;
        while ((l = instream.read(buf)) != -1) {
            outstream.write(buf, 0, l);
            if (limit2 == null || (total2 += (long)l) <= limit2.getValue()) continue;
            limit2.reached();
            break;
        }
        return new HeapResource(outstream.toByteArray());
    }

    public Resource copy(String requestId, Resource resource2) throws IOException {
        byte[] body;
        if (resource2 instanceof HeapResource) {
            body = ((HeapResource)resource2).getByteArray();
        } else {
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            IOUtils.copyAndClose(resource2.getInputStream(), outstream);
            body = outstream.toByteArray();
        }
        return new HeapResource(body);
    }
}

