/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class AbstractCookieSpec
implements CookieSpec {
    private final Map<String, CookieAttributeHandler> attribHandlerMap = new HashMap<String, CookieAttributeHandler>(10);

    public void registerAttribHandler(String name2, CookieAttributeHandler handler) {
        if (name2 == null) {
            throw new IllegalArgumentException("Attribute name may not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Attribute handler may not be null");
        }
        this.attribHandlerMap.put(name2, handler);
    }

    protected CookieAttributeHandler findAttribHandler(String name2) {
        return this.attribHandlerMap.get(name2);
    }

    protected CookieAttributeHandler getAttribHandler(String name2) {
        CookieAttributeHandler handler = this.findAttribHandler(name2);
        if (handler == null) {
            throw new IllegalStateException("Handler not registered for " + name2 + " attribute.");
        }
        return handler;
    }

    protected Collection<CookieAttributeHandler> getAttribHandlers() {
        return this.attribHandlerMap.values();
    }
}

