/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class NetscapeDraftHeaderParser {
    public static final NetscapeDraftHeaderParser DEFAULT = new NetscapeDraftHeaderParser();

    public HeaderElement parseHeader(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (cursor == null) {
            throw new IllegalArgumentException("Parser cursor may not be null");
        }
        NameValuePair nvp = this.parseNameValuePair(buffer, cursor);
        ArrayList<NameValuePair> params2 = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair param = this.parseNameValuePair(buffer, cursor);
            params2.add(param);
        }
        return new BasicHeaderElement(nvp.getName(), nvp.getValue(), params2.toArray(new NameValuePair[params2.size()]));
    }

    private NameValuePair parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor) {
        char ch;
        int pos2;
        boolean terminated = false;
        int indexFrom = cursor.getPos();
        int indexTo = cursor.getUpperBound();
        String name2 = null;
        for (pos2 = cursor.getPos(); pos2 < indexTo && (ch = buffer.charAt(pos2)) != '='; ++pos2) {
            if (ch != ';') continue;
            terminated = true;
            break;
        }
        if (pos2 == indexTo) {
            terminated = true;
            name2 = buffer.substringTrimmed(indexFrom, indexTo);
        } else {
            name2 = buffer.substringTrimmed(indexFrom, pos2);
            ++pos2;
        }
        if (terminated) {
            cursor.updatePos(pos2);
            return new BasicNameValuePair(name2, null);
        }
        String value2 = null;
        int i1 = pos2;
        while (pos2 < indexTo) {
            char ch2 = buffer.charAt(pos2);
            if (ch2 == ';') {
                terminated = true;
                break;
            }
            ++pos2;
        }
        int i2 = pos2;
        while (i1 < i2 && HTTP.isWhitespace(buffer.charAt(i1))) {
            ++i1;
        }
        while (i2 > i1 && HTTP.isWhitespace(buffer.charAt(i2 - 1))) {
            --i2;
        }
        value2 = buffer.substring(i1, i2);
        if (terminated) {
            ++pos2;
        }
        cursor.updatePos(pos2);
        return new BasicNameValuePair(name2, value2);
    }
}

