/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import org.apache.http.impl.io.AbstractSessionInputBuffer;
import org.apache.http.io.EofSensor;
import org.apache.http.params.HttpParams;

public class SocketInputBuffer
extends AbstractSessionInputBuffer
implements EofSensor {
    private static final Class SOCKET_TIMEOUT_CLASS = SocketInputBuffer.SocketTimeoutExceptionClass();
    private final Socket socket;
    private boolean eof;

    private static Class SocketTimeoutExceptionClass() {
        try {
            return Class.forName("java.net.SocketTimeoutException");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static boolean isSocketTimeoutException(InterruptedIOException e) {
        if (SOCKET_TIMEOUT_CLASS != null) {
            return SOCKET_TIMEOUT_CLASS.isInstance(e);
        }
        return true;
    }

    public SocketInputBuffer(Socket socket2, int buffersize, HttpParams params2) throws IOException {
        if (socket2 == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        this.socket = socket2;
        this.eof = false;
        if (buffersize < 0) {
            buffersize = socket2.getReceiveBufferSize();
        }
        if (buffersize < 1024) {
            buffersize = 1024;
        }
        this.init(socket2.getInputStream(), buffersize, params2);
    }

    protected int fillBuffer() throws IOException {
        int i2 = super.fillBuffer();
        this.eof = i2 == -1;
        return i2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable(int timeout2) throws IOException {
        boolean result2 = this.hasBufferedData();
        if (!result2) {
            int oldtimeout = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(timeout2);
                this.fillBuffer();
                result2 = this.hasBufferedData();
            }
            catch (InterruptedIOException e) {
                if (!SocketInputBuffer.isSocketTimeoutException(e)) {
                    throw e;
                }
            }
            finally {
                this.socket.setSoTimeout(oldtimeout);
            }
        }
        return result2;
    }

    public boolean isEof() {
        return this.eof;
    }
}

