/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import org.apache.http.params.HttpParams;

public abstract class AbstractHttpParams
implements HttpParams {
    protected AbstractHttpParams() {
    }

    public long getLongParameter(String name2, long defaultValue) {
        Object param = this.getParameter(name2);
        if (param == null) {
            return defaultValue;
        }
        return (Long)param;
    }

    public HttpParams setLongParameter(String name2, long value2) {
        this.setParameter(name2, new Long(value2));
        return this;
    }

    public int getIntParameter(String name2, int defaultValue) {
        Object param = this.getParameter(name2);
        if (param == null) {
            return defaultValue;
        }
        return (Integer)param;
    }

    public HttpParams setIntParameter(String name2, int value2) {
        this.setParameter(name2, new Integer(value2));
        return this;
    }

    public double getDoubleParameter(String name2, double defaultValue) {
        Object param = this.getParameter(name2);
        if (param == null) {
            return defaultValue;
        }
        return (Double)param;
    }

    public HttpParams setDoubleParameter(String name2, double value2) {
        this.setParameter(name2, new Double(value2));
        return this;
    }

    public boolean getBooleanParameter(String name2, boolean defaultValue) {
        Object param = this.getParameter(name2);
        if (param == null) {
            return defaultValue;
        }
        return (Boolean)param;
    }

    public HttpParams setBooleanParameter(String name2, boolean value2) {
        this.setParameter(name2, value2 ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public boolean isParameterTrue(String name2) {
        return this.getBooleanParameter(name2, false);
    }

    public boolean isParameterFalse(String name2) {
        return !this.getBooleanParameter(name2, false);
    }
}

