/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.util.ArrayList;
import java.util.List;

public abstract class NameAbbreviator {
    private static final NameAbbreviator DEFAULT = new NOPAbbreviator();

    public static NameAbbreviator getAbbreviator(String pattern) {
        if (pattern.length() > 0) {
            String trimmed = pattern.trim();
            if (trimmed.length() == 0) {
                return DEFAULT;
            }
            int i2 = 0;
            if (trimmed.length() > 0) {
                if (trimmed.charAt(0) == '-') {
                    ++i2;
                }
                while (i2 < trimmed.length() && trimmed.charAt(i2) >= '0' && trimmed.charAt(i2) <= '9') {
                    ++i2;
                }
            }
            if (i2 == trimmed.length()) {
                int elements = Integer.parseInt(trimmed);
                if (elements >= 0) {
                    return new MaxElementAbbreviator(elements);
                }
                return new DropElementAbbreviator(-elements);
            }
            ArrayList<PatternAbbreviatorFragment> fragments = new ArrayList<PatternAbbreviatorFragment>(5);
            for (int pos2 = 0; pos2 < trimmed.length() && pos2 >= 0; ++pos2) {
                int charCount;
                int ellipsisPos = pos2;
                if (trimmed.charAt(pos2) == '*') {
                    charCount = Integer.MAX_VALUE;
                    ++ellipsisPos;
                } else if (trimmed.charAt(pos2) >= '0' && trimmed.charAt(pos2) <= '9') {
                    charCount = trimmed.charAt(pos2) - 48;
                    ++ellipsisPos;
                } else {
                    charCount = 0;
                }
                char ellipsis = '\u0000';
                if (ellipsisPos < trimmed.length() && (ellipsis = trimmed.charAt(ellipsisPos)) == '.') {
                    ellipsis = '\u0000';
                }
                fragments.add(new PatternAbbreviatorFragment(charCount, ellipsis));
                pos2 = trimmed.indexOf(".", pos2);
                if (pos2 == -1) break;
            }
            return new PatternAbbreviator(fragments);
        }
        return DEFAULT;
    }

    public static NameAbbreviator getDefaultAbbreviator() {
        return DEFAULT;
    }

    public abstract void abbreviate(int var1, StringBuffer var2);

    private static class PatternAbbreviator
    extends NameAbbreviator {
        private final PatternAbbreviatorFragment[] fragments;

        public PatternAbbreviator(List fragments) {
            if (fragments.size() == 0) {
                throw new IllegalArgumentException("fragments must have at least one element");
            }
            this.fragments = new PatternAbbreviatorFragment[fragments.size()];
            fragments.toArray(this.fragments);
        }

        public void abbreviate(int nameStart, StringBuffer buf) {
            int pos2 = nameStart;
            for (int i2 = 0; i2 < this.fragments.length - 1 && pos2 < buf.length(); ++i2) {
                pos2 = this.fragments[i2].abbreviate(buf, pos2);
            }
            PatternAbbreviatorFragment terminalFragment = this.fragments[this.fragments.length - 1];
            while (pos2 < buf.length() && pos2 >= 0) {
                pos2 = terminalFragment.abbreviate(buf, pos2);
            }
        }
    }

    private static class PatternAbbreviatorFragment {
        private final int charCount;
        private final char ellipsis;

        public PatternAbbreviatorFragment(int charCount, char ellipsis) {
            this.charCount = charCount;
            this.ellipsis = ellipsis;
        }

        public int abbreviate(StringBuffer buf, int startPos) {
            int nextDot = buf.toString().indexOf(".", startPos);
            if (nextDot != -1) {
                if (nextDot - startPos > this.charCount) {
                    buf.delete(startPos + this.charCount, nextDot);
                    nextDot = startPos + this.charCount;
                    if (this.ellipsis != '\u0000') {
                        buf.insert(nextDot, this.ellipsis);
                        ++nextDot;
                    }
                }
                ++nextDot;
            }
            return nextDot;
        }
    }

    private static class DropElementAbbreviator
    extends NameAbbreviator {
        private final int count;

        public DropElementAbbreviator(int count2) {
            this.count = count2;
        }

        public void abbreviate(int nameStart, StringBuffer buf) {
            int i2 = this.count;
            int pos2 = buf.indexOf(".", nameStart);
            while (pos2 != -1) {
                if (--i2 == 0) {
                    buf.delete(nameStart, pos2 + 1);
                    break;
                }
                pos2 = buf.indexOf(".", pos2 + 1);
            }
        }
    }

    private static class MaxElementAbbreviator
    extends NameAbbreviator {
        private final int count;

        public MaxElementAbbreviator(int count2) {
            this.count = count2;
        }

        public void abbreviate(int nameStart, StringBuffer buf) {
            int end2 = buf.length() - 1;
            String bufString = buf.toString();
            for (int i2 = this.count; i2 > 0; --i2) {
                if ((end2 = bufString.lastIndexOf(".", end2 - 1)) != -1 && end2 >= nameStart) continue;
                return;
            }
            buf.delete(nameStart, end2 + 1);
        }
    }

    private static class NOPAbbreviator
    extends NameAbbreviator {
        public void abbreviate(int nameStart, StringBuffer buf) {
        }
    }
}

