/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.CharacterUtils;
import org.apache.lucene.util.Version;

public final class LowerCaseFilter
extends TokenFilter {
    private final CharacterUtils charUtils;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public LowerCaseFilter(Version matchVersion, TokenStream in) {
        super(in);
        this.charUtils = CharacterUtils.getInstance(matchVersion);
    }

    @Deprecated
    public LowerCaseFilter(TokenStream in) {
        this(Version.LUCENE_30, in);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length2 = this.termAtt.length();
            for (int i2 = 0; i2 < length2; i2 += Character.toChars(Character.toLowerCase(this.charUtils.codePointAt(buffer, i2)), buffer, i2)) {
            }
            return true;
        }
        return false;
    }
}

