/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.apache.lucene.analysis.BaseCharFilter;
import org.apache.lucene.analysis.CharReader;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.NormalizeCharMap;

public class MappingCharFilter
extends BaseCharFilter {
    private final NormalizeCharMap normMap;
    private LinkedList<Character> buffer;
    private String replacement;
    private int charPointer;
    private int nextCharCounter;

    public MappingCharFilter(NormalizeCharMap normMap, CharStream in) {
        super(in);
        this.normMap = normMap;
    }

    public MappingCharFilter(NormalizeCharMap normMap, Reader in) {
        super(CharReader.get(in));
        this.normMap = normMap;
    }

    public int read() throws IOException {
        block0: while (this.replacement == null || this.charPointer >= this.replacement.length()) {
            NormalizeCharMap nm;
            int firstChar = this.nextChar();
            if (firstChar == -1) {
                return -1;
            }
            NormalizeCharMap normalizeCharMap = nm = this.normMap.submap != null ? this.normMap.submap.get(Character.valueOf((char)firstChar)) : null;
            if (nm == null) {
                return firstChar;
            }
            NormalizeCharMap result2 = this.match(nm);
            if (result2 == null) {
                return firstChar;
            }
            this.replacement = result2.normStr;
            this.charPointer = 0;
            if (result2.diff == 0) continue;
            int prevCumulativeDiff = this.getLastCumulativeDiff();
            if (result2.diff < 0) {
                int i2 = 0;
                while (true) {
                    if (i2 >= -result2.diff) continue block0;
                    this.addOffCorrectMap(this.nextCharCounter + i2 - prevCumulativeDiff, prevCumulativeDiff - 1 - i2);
                    ++i2;
                }
            }
            this.addOffCorrectMap(this.nextCharCounter - result2.diff - prevCumulativeDiff, prevCumulativeDiff + result2.diff);
        }
        return this.replacement.charAt(this.charPointer++);
    }

    private int nextChar() throws IOException {
        if (this.buffer != null && !this.buffer.isEmpty()) {
            ++this.nextCharCounter;
            return this.buffer.removeFirst().charValue();
        }
        int nextChar = this.input.read();
        if (nextChar != -1) {
            ++this.nextCharCounter;
        }
        return nextChar;
    }

    private void pushChar(int c) {
        --this.nextCharCounter;
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        this.buffer.addFirst(Character.valueOf((char)c));
    }

    private void pushLastChar(int c) {
        if (this.buffer == null) {
            this.buffer = new LinkedList();
        }
        this.buffer.addLast(Character.valueOf((char)c));
    }

    private NormalizeCharMap match(NormalizeCharMap map) throws IOException {
        int chr2;
        NormalizeCharMap result2 = null;
        if (map.submap != null && (chr2 = this.nextChar()) != -1) {
            NormalizeCharMap subMap = map.submap.get(Character.valueOf((char)chr2));
            if (subMap != null) {
                result2 = this.match(subMap);
            }
            if (result2 == null) {
                this.pushChar(chr2);
            }
        }
        if (result2 == null && map.normStr != null) {
            result2 = map;
        }
        return result2;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int i2;
        char[] tmp = new char[len];
        int l = this.input.read(tmp, 0, len);
        if (l != -1) {
            for (i2 = 0; i2 < l; ++i2) {
                this.pushLastChar(tmp[i2]);
            }
        }
        l = 0;
        for (i2 = off; i2 < off + len && (c = this.read()) != -1; ++i2) {
            cbuf[i2] = (char)c;
            ++l;
        }
        return l == 0 ? -1 : l;
    }
}

