/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanStemmer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GermanStemFilter
extends TokenFilter {
    private GermanStemmer stemmer = new GermanStemmer();
    private Set<?> exclusionSet = null;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public GermanStemFilter(TokenStream in) {
        super(in);
    }

    @Deprecated
    public GermanStemFilter(TokenStream in, Set<?> exclusionSet) {
        this(in);
        this.exclusionSet = exclusionSet;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String s2;
            String term = this.termAtt.toString();
            if (!(this.keywordAttr.isKeyword() || this.exclusionSet != null && this.exclusionSet.contains(term) || (s2 = this.stemmer.stem(term)) == null || s2.equals(term))) {
                this.termAtt.setEmpty().append(s2);
            }
            return true;
        }
        return false;
    }

    public void setStemmer(GermanStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    @Deprecated
    public void setExclusionSet(Set<?> exclusionSet) {
        this.exclusionSet = exclusionSet;
    }
}

