/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.el;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.apache.lucene.analysis.el.GreekStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GreekAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";

    public static final Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public GreekAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_SET);
    }

    public GreekAnalyzer(Version matchVersion, Set<?> stopwords) {
        super(matchVersion, stopwords);
    }

    @Deprecated
    public GreekAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet(matchVersion, stopwords));
    }

    @Deprecated
    public GreekAnalyzer(Version matchVersion, Map<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source2 = new StandardTokenizer(this.matchVersion, reader);
        TokenFilter result2 = new GreekLowerCaseFilter(this.matchVersion, source2);
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            result2 = new StandardFilter(this.matchVersion, result2);
        }
        result2 = new StopFilter(this.matchVersion, (TokenStream)result2, this.stopwords);
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            result2 = new GreekStemFilter(result2);
        }
        return new ReusableAnalyzerBase.TokenStreamComponents(source2, result2);
    }

    private static class DefaultSetHolder {
        private static final Set<?> DEFAULT_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_SET = GreekAnalyzer.loadStopwordSet(false, GreekAnalyzer.class, GreekAnalyzer.DEFAULT_STOPWORD_FILE, "#");
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

