/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.lucene.analysis.nl.DutchStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.DutchStemmer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DutchAnalyzer
extends ReusableAnalyzerBase {
    @Deprecated
    public static final String[] DUTCH_STOP_WORDS;
    public static final String DEFAULT_STOPWORD_FILE = "dutch_stop.txt";
    private final Set<?> stoptable;
    private Set<?> excltable = Collections.emptySet();
    private CharArrayMap<String> stemdict = CharArrayMap.emptyMap();
    private final Version matchVersion;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public DutchAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET, CharArraySet.EMPTY_SET, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, CharArraySet.EMPTY_SET, matchVersion.onOrAfter(Version.LUCENE_36) ? DefaultSetHolder.DEFAULT_STEM_DICT : CharArrayMap.emptyMap());
    }

    public DutchAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionTable) {
        this(matchVersion, stopwords, stemExclusionTable, matchVersion.onOrAfter(Version.LUCENE_36) ? DefaultSetHolder.DEFAULT_STEM_DICT : CharArrayMap.emptyMap());
    }

    public DutchAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionTable, CharArrayMap<String> stemOverrideDict) {
        this.matchVersion = matchVersion;
        this.stoptable = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stopwords));
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stemExclusionTable));
        this.stemdict = CharArrayMap.unmodifiableMap(CharArrayMap.copy(matchVersion, stemOverrideDict));
    }

    @Deprecated
    public DutchAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet(matchVersion, stopwords));
    }

    @Deprecated
    public DutchAnalyzer(Version matchVersion, HashSet<?> stopwords) {
        this(matchVersion, (Set<?>)stopwords);
    }

    @Deprecated
    public DutchAnalyzer(Version matchVersion, File stopwords) {
        try {
            this.stoptable = WordlistLoader.getWordSet(IOUtils.getDecodingReader(stopwords, IOUtils.CHARSET_UTF_8), matchVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.matchVersion = matchVersion;
    }

    @Deprecated
    public void setStemExclusionTable(String ... exclusionlist) {
        this.excltable = StopFilter.makeStopSet(this.matchVersion, exclusionlist);
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(HashSet<?> exclusionlist) {
        this.excltable = exclusionlist;
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(File exclusionlist) {
        try {
            this.excltable = WordlistLoader.getWordSet(IOUtils.getDecodingReader(exclusionlist, IOUtils.CHARSET_UTF_8), this.matchVersion);
            this.setPreviousTokenStream(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void setStemDictionary(File stemdictFile) {
        try {
            this.stemdict = WordlistLoader.getStemDict(IOUtils.getDecodingReader(stemdictFile, IOUtils.CHARSET_UTF_8), new CharArrayMap<String>(this.matchVersion, 16, false));
            this.setPreviousTokenStream(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader aReader) {
        if (this.matchVersion.onOrAfter(Version.LUCENE_31)) {
            StandardTokenizer source2 = new StandardTokenizer(this.matchVersion, aReader);
            TokenFilter result2 = new StandardFilter(this.matchVersion, source2);
            result2 = new LowerCaseFilter(this.matchVersion, result2);
            result2 = new StopFilter(this.matchVersion, (TokenStream)result2, this.stoptable);
            if (!this.excltable.isEmpty()) {
                result2 = new KeywordMarkerFilter((TokenStream)result2, this.excltable);
            }
            if (!this.stemdict.isEmpty()) {
                result2 = new StemmerOverrideFilter(this.matchVersion, result2, this.stemdict);
            }
            result2 = new SnowballFilter((TokenStream)result2, new DutchStemmer());
            return new ReusableAnalyzerBase.TokenStreamComponents(source2, result2);
        }
        StandardTokenizer source3 = new StandardTokenizer(this.matchVersion, aReader);
        TokenFilter result3 = new StandardFilter(this.matchVersion, source3);
        result3 = new StopFilter(this.matchVersion, (TokenStream)result3, this.stoptable);
        if (!this.excltable.isEmpty()) {
            result3 = new KeywordMarkerFilter((TokenStream)result3, this.excltable);
        }
        result3 = new DutchStemFilter((TokenStream)result3, this.stemdict);
        return new ReusableAnalyzerBase.TokenStreamComponents(source3, result3);
    }

    static {
        Set<?> defaultStopSet = DutchAnalyzer.getDefaultStopSet();
        DUTCH_STOP_WORDS = new String[defaultStopSet.size()];
        int i2 = 0;
        for (Object object : defaultStopSet) {
            DutchAnalyzer.DUTCH_STOP_WORDS[i2++] = new String((char[])object);
        }
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;
        static final CharArrayMap<String> DEFAULT_STEM_DICT;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.getDecodingReader(SnowballFilter.class, DutchAnalyzer.DEFAULT_STOPWORD_FILE, IOUtils.CHARSET_UTF_8), Version.LUCENE_CURRENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
            DEFAULT_STEM_DICT = new CharArrayMap(Version.LUCENE_CURRENT, 4, false);
            DEFAULT_STEM_DICT.put("fiets", "fiets");
            DEFAULT_STEM_DICT.put("bromfiets", "bromfiets");
            DEFAULT_STEM_DICT.put("ei", "eier");
            DEFAULT_STEM_DICT.put("kind", "kinder");
        }
    }
}

