/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.util.Map;

@Deprecated
public class DutchStemmer {
    private StringBuilder sb = new StringBuilder();
    private boolean _removedE;
    private Map _stemDict;
    private int _R1;
    private int _R2;

    public String stem(String term) {
        if (!this.isStemmable(term = term.toLowerCase())) {
            return term;
        }
        if (this._stemDict != null && this._stemDict.containsKey(term)) {
            if (this._stemDict.get(term) instanceof String) {
                return (String)this._stemDict.get(term);
            }
            return null;
        }
        this.sb.delete(0, this.sb.length());
        this.sb.insert(0, term);
        this.substitute(this.sb);
        this.storeYandI(this.sb);
        this._R1 = this.getRIndex(this.sb, 0);
        this._R1 = Math.max(3, this._R1);
        this.step1(this.sb);
        this.step2(this.sb);
        this._R2 = this.getRIndex(this.sb, this._R1);
        this.step3a(this.sb);
        this.step3b(this.sb);
        this.step4(this.sb);
        this.reStoreYandI(this.sb);
        return this.sb.toString();
    }

    private boolean enEnding(StringBuilder sb) {
        String[] enend = new String[]{"ene", "en"};
        for (int i2 = 0; i2 < enend.length; ++i2) {
            String end2 = enend[i2];
            String s2 = sb.toString();
            int index2 = s2.length() - end2.length();
            if (!s2.endsWith(end2) || index2 < this._R1 || !this.isValidEnEnding(sb, index2 - 1)) continue;
            sb.delete(index2, index2 + end2.length());
            this.unDouble(sb, index2);
            return true;
        }
        return false;
    }

    private void step1(StringBuilder sb) {
        int index2;
        if (this._R1 >= sb.length()) {
            return;
        }
        String s2 = sb.toString();
        int lengthR1 = sb.length() - this._R1;
        if (s2.endsWith("heden")) {
            sb.replace(this._R1, lengthR1 + this._R1, sb.substring(this._R1, lengthR1 + this._R1).replaceAll("heden", "heid"));
            return;
        }
        if (this.enEnding(sb)) {
            return;
        }
        if (s2.endsWith("se") && (index2 = s2.length() - 2) >= this._R1 && this.isValidSEnding(sb, index2 - 1)) {
            sb.delete(index2, index2 + 2);
            return;
        }
        if (s2.endsWith("s") && (index2 = s2.length() - 1) >= this._R1 && this.isValidSEnding(sb, index2 - 1)) {
            sb.delete(index2, index2 + 1);
        }
    }

    private void step2(StringBuilder sb) {
        this._removedE = false;
        if (this._R1 >= sb.length()) {
            return;
        }
        String s2 = sb.toString();
        int index2 = s2.length() - 1;
        if (index2 >= this._R1 && s2.endsWith("e") && !this.isVowel(sb.charAt(index2 - 1))) {
            sb.delete(index2, index2 + 1);
            this.unDouble(sb);
            this._removedE = true;
        }
    }

    private void step3a(StringBuilder sb) {
        if (this._R2 >= sb.length()) {
            return;
        }
        String s2 = sb.toString();
        int index2 = s2.length() - 4;
        if (s2.endsWith("heid") && index2 >= this._R2 && sb.charAt(index2 - 1) != 'c') {
            sb.delete(index2, index2 + 4);
            this.enEnding(sb);
        }
    }

    private void step3b(StringBuilder sb) {
        if (this._R2 >= sb.length()) {
            return;
        }
        String s2 = sb.toString();
        int index2 = 0;
        if ((s2.endsWith("end") || s2.endsWith("ing")) && (index2 = s2.length() - 3) >= this._R2) {
            sb.delete(index2, index2 + 3);
            if (sb.charAt(index2 - 2) == 'i' && sb.charAt(index2 - 1) == 'g') {
                if (sb.charAt(index2 - 3) != 'e' & index2 - 2 >= this._R2) {
                    sb.delete(index2 -= 2, index2 + 2);
                }
            } else {
                this.unDouble(sb, index2);
            }
            return;
        }
        if (s2.endsWith("ig") && (index2 = s2.length() - 2) >= this._R2) {
            if (sb.charAt(index2 - 1) != 'e') {
                sb.delete(index2, index2 + 2);
            }
            return;
        }
        if (s2.endsWith("lijk") && (index2 = s2.length() - 4) >= this._R2) {
            sb.delete(index2, index2 + 4);
            this.step2(sb);
            return;
        }
        if (s2.endsWith("baar") && (index2 = s2.length() - 4) >= this._R2) {
            sb.delete(index2, index2 + 4);
            return;
        }
        if (s2.endsWith("bar") && (index2 = s2.length() - 3) >= this._R2) {
            if (this._removedE) {
                sb.delete(index2, index2 + 3);
            }
            return;
        }
    }

    private void step4(StringBuilder sb) {
        if (sb.length() < 4) {
            return;
        }
        String end2 = sb.substring(sb.length() - 4, sb.length());
        char c = end2.charAt(0);
        char v1 = end2.charAt(1);
        char v2 = end2.charAt(2);
        char d = end2.charAt(3);
        if (v1 == v2 && d != 'I' && v1 != 'i' && this.isVowel(v1) && !this.isVowel(d) && !this.isVowel(c)) {
            sb.delete(sb.length() - 2, sb.length() - 1);
        }
    }

    private boolean isStemmable(String term) {
        for (int c = 0; c < term.length(); ++c) {
            if (Character.isLetter(term.charAt(c))) continue;
            return false;
        }
        return true;
    }

    private void substitute(StringBuilder buffer) {
        block7: for (int i2 = 0; i2 < buffer.length(); ++i2) {
            switch (buffer.charAt(i2)) {
                case '\u00e1': 
                case '\u00e4': {
                    buffer.setCharAt(i2, 'a');
                    continue block7;
                }
                case '\u00e9': 
                case '\u00eb': {
                    buffer.setCharAt(i2, 'e');
                    continue block7;
                }
                case '\u00fa': 
                case '\u00fc': {
                    buffer.setCharAt(i2, 'u');
                    continue block7;
                }
                case 'i': 
                case '\u00ef': {
                    buffer.setCharAt(i2, 'i');
                    continue block7;
                }
                case '\u00f3': 
                case '\u00f6': {
                    buffer.setCharAt(i2, 'o');
                }
            }
        }
    }

    private boolean isValidSEnding(StringBuilder sb, int index2) {
        char c = sb.charAt(index2);
        return !this.isVowel(c) && c != 'j';
    }

    private boolean isValidEnEnding(StringBuilder sb, int index2) {
        char c = sb.charAt(index2);
        if (this.isVowel(c)) {
            return false;
        }
        if (c < '\u0003') {
            return false;
        }
        return c != 'm' || sb.charAt(index2 - 2) != 'g' || sb.charAt(index2 - 1) != 'e';
    }

    private void unDouble(StringBuilder sb) {
        this.unDouble(sb, sb.length());
    }

    private void unDouble(StringBuilder sb, int endIndex) {
        String s2 = sb.substring(0, endIndex);
        if (s2.endsWith("kk") || s2.endsWith("tt") || s2.endsWith("dd") || s2.endsWith("nn") || s2.endsWith("mm") || s2.endsWith("ff")) {
            sb.delete(endIndex - 1, endIndex);
        }
    }

    private int getRIndex(StringBuilder sb, int start2) {
        int i2;
        if (start2 == 0) {
            start2 = 1;
        }
        for (i2 = start2; i2 < sb.length(); ++i2) {
            if (this.isVowel(sb.charAt(i2)) || !this.isVowel(sb.charAt(i2 - 1))) continue;
            return i2 + 1;
        }
        return i2 + 1;
    }

    private void storeYandI(StringBuilder sb) {
        if (sb.charAt(0) == 'y') {
            sb.setCharAt(0, 'Y');
        }
        int last2 = sb.length() - 1;
        block4: for (int i2 = 1; i2 < last2; ++i2) {
            switch (sb.charAt(i2)) {
                case 'i': {
                    if (!this.isVowel(sb.charAt(i2 - 1)) || !this.isVowel(sb.charAt(i2 + 1))) continue block4;
                    sb.setCharAt(i2, 'I');
                    continue block4;
                }
                case 'y': {
                    if (!this.isVowel(sb.charAt(i2 - 1))) continue block4;
                    sb.setCharAt(i2, 'Y');
                }
            }
        }
        if (last2 > 0 && sb.charAt(last2) == 'y' && this.isVowel(sb.charAt(last2 - 1))) {
            sb.setCharAt(last2, 'Y');
        }
    }

    private void reStoreYandI(StringBuilder sb) {
        String tmp = sb.toString();
        sb.delete(0, sb.length());
        sb.insert(0, tmp.replaceAll("I", "i").replaceAll("Y", "y"));
    }

    private boolean isVowel(char c) {
        switch (c) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': 
            case 'y': 
            case '\u00e8': {
                return true;
            }
        }
        return false;
    }

    void setStemDictionary(Map dict) {
        this._stemDict = dict;
    }
}

