/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.lucene.analysis.payloads.AbstractEncoder;
import org.apache.lucene.analysis.payloads.PayloadEncoder;
import org.apache.lucene.index.Payload;

public class IdentityEncoder
extends AbstractEncoder
implements PayloadEncoder {
    protected Charset charset = Charset.forName("UTF-8");
    @Deprecated
    protected String charsetName = this.charset.name();

    public IdentityEncoder() {
    }

    public IdentityEncoder(Charset charset) {
        this.charset = charset;
        this.charsetName = charset.name();
    }

    public Payload encode(char[] buffer, int offset2, int length2) {
        ByteBuffer bb = this.charset.encode(CharBuffer.wrap(buffer, offset2, length2));
        if (bb.hasArray()) {
            return new Payload(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining());
        }
        byte[] b = new byte[bb.remaining()];
        bb.get(b);
        return new Payload(b);
    }
}

