/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.query;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.ReaderUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryAutoStopWordAnalyzer
extends Analyzer {
    private final Analyzer delegate;
    private final Map<String, Set<String>> stopWordsPerField = new HashMap<String, Set<String>>();
    public static final float defaultMaxDocFreqPercent = 0.4f;
    private final Version matchVersion;

    @Deprecated
    public QueryAutoStopWordAnalyzer(Version matchVersion, Analyzer delegate2) {
        this.delegate = delegate2;
        this.matchVersion = matchVersion;
    }

    public QueryAutoStopWordAnalyzer(Version matchVersion, Analyzer delegate2, IndexReader indexReader) throws IOException {
        this(matchVersion, delegate2, indexReader, 0.4f);
    }

    public QueryAutoStopWordAnalyzer(Version matchVersion, Analyzer delegate2, IndexReader indexReader, int maxDocFreq) throws IOException {
        this(matchVersion, delegate2, indexReader, ReaderUtil.getIndexedFields(indexReader), maxDocFreq);
    }

    public QueryAutoStopWordAnalyzer(Version matchVersion, Analyzer delegate2, IndexReader indexReader, float maxPercentDocs) throws IOException {
        this(matchVersion, delegate2, indexReader, ReaderUtil.getIndexedFields(indexReader), maxPercentDocs);
    }

    public QueryAutoStopWordAnalyzer(Version matchVersion, Analyzer delegate2, IndexReader indexReader, Collection<String> fields2, float maxPercentDocs) throws IOException {
        this(matchVersion, delegate2, indexReader, fields2, (int)((float)indexReader.numDocs() * maxPercentDocs));
    }

    public QueryAutoStopWordAnalyzer(Version matchVersion, Analyzer delegate2, IndexReader indexReader, Collection<String> fields2, int maxDocFreq) throws IOException {
        this.matchVersion = matchVersion;
        this.delegate = delegate2;
        for (String field2 : fields2) {
            HashSet<String> stopWords = new HashSet<String>();
            String internedFieldName = StringHelper.intern(field2);
            TermEnum te = indexReader.terms(new Term(field2));
            Term term = te.term();
            while (term != null && term.field() == internedFieldName) {
                if (te.docFreq() > maxDocFreq) {
                    stopWords.add(term.text());
                }
                if (!te.next()) break;
                term = te.term();
            }
            this.stopWordsPerField.put(field2, stopWords);
        }
    }

    @Deprecated
    public int addStopWords(IndexReader reader) throws IOException {
        return this.addStopWords(reader, 0.4f);
    }

    @Deprecated
    public int addStopWords(IndexReader reader, int maxDocFreq) throws IOException {
        int numStopWords = 0;
        Collection<String> fieldNames = ReaderUtil.getIndexedFields(reader);
        for (String fieldName : fieldNames) {
            numStopWords += this.addStopWords(reader, fieldName, maxDocFreq);
        }
        return numStopWords;
    }

    @Deprecated
    public int addStopWords(IndexReader reader, float maxPercentDocs) throws IOException {
        int numStopWords = 0;
        Collection<String> fieldNames = ReaderUtil.getIndexedFields(reader);
        for (String fieldName : fieldNames) {
            numStopWords += this.addStopWords(reader, fieldName, maxPercentDocs);
        }
        return numStopWords;
    }

    @Deprecated
    public int addStopWords(IndexReader reader, String fieldName, float maxPercentDocs) throws IOException {
        return this.addStopWords(reader, fieldName, (int)((float)reader.numDocs() * maxPercentDocs));
    }

    @Deprecated
    public int addStopWords(IndexReader reader, String fieldName, int maxDocFreq) throws IOException {
        HashSet<String> stopWords = new HashSet<String>();
        String internedFieldName = StringHelper.intern(fieldName);
        TermEnum te = reader.terms(new Term(fieldName));
        Term term = te.term();
        while (term != null && term.field() == internedFieldName) {
            if (te.docFreq() > maxDocFreq) {
                stopWords.add(term.text());
            }
            if (!te.next()) break;
            term = te.term();
        }
        this.stopWordsPerField.put(fieldName, stopWords);
        Map streamMap = (Map)this.getPreviousTokenStream();
        if (streamMap != null) {
            streamMap.remove(fieldName);
        }
        return stopWords.size();
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result2;
        try {
            result2 = this.delegate.reusableTokenStream(fieldName, reader);
        }
        catch (IOException e) {
            result2 = this.delegate.tokenStream(fieldName, reader);
        }
        Set<String> stopWords = this.stopWordsPerField.get(fieldName);
        if (stopWords != null) {
            result2 = new StopFilter(this.matchVersion, result2, stopWords);
        }
        return result2;
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams;
        HashMap<String, SavedStreams> streamMap = (HashMap<String, SavedStreams>)this.getPreviousTokenStream();
        if (streamMap == null) {
            streamMap = new HashMap<String, SavedStreams>();
            this.setPreviousTokenStream(streamMap);
        }
        if ((streams = (SavedStreams)streamMap.get(fieldName)) == null) {
            streams = new SavedStreams();
            streamMap.put(fieldName, streams);
            streams.wrapped = this.delegate.reusableTokenStream(fieldName, reader);
            Set<String> stopWords = this.stopWordsPerField.get(fieldName);
            streams.withStopFilter = stopWords != null ? new StopFilter(this.matchVersion, streams.wrapped, stopWords) : streams.wrapped;
        } else {
            TokenStream result2 = this.delegate.reusableTokenStream(fieldName, reader);
            if (result2 != streams.wrapped) {
                streams.wrapped = result2;
                Set<String> stopWords = this.stopWordsPerField.get(fieldName);
                streams.withStopFilter = stopWords != null ? new StopFilter(this.matchVersion, streams.wrapped, stopWords) : streams.wrapped;
            }
        }
        return streams.withStopFilter;
    }

    public String[] getStopWords(String fieldName) {
        Set<String> stopWords = this.stopWordsPerField.get(fieldName);
        return stopWords != null ? stopWords.toArray(new String[stopWords.size()]) : new String[]{};
    }

    public Term[] getStopWords() {
        ArrayList<Term> allStopWords = new ArrayList<Term>();
        for (String fieldName : this.stopWordsPerField.keySet()) {
            Set<String> stopWords = this.stopWordsPerField.get(fieldName);
            for (String text : stopWords) {
                allStopWords.add(new Term(fieldName, text));
            }
        }
        return allStopWords.toArray(new Term[allStopWords.size()]);
    }

    private class SavedStreams {
        TokenStream wrapped;
        TokenStream withStopFilter;

        private SavedStreams() {
        }
    }
}

