/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tr.TurkishLowerCaseFilter;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class SnowballAnalyzer
extends Analyzer {
    private String name;
    private Set<?> stopSet;
    private final Version matchVersion;

    public SnowballAnalyzer(Version matchVersion, String name2) {
        this.name = name2;
        this.matchVersion = matchVersion;
    }

    @Deprecated
    public SnowballAnalyzer(Version matchVersion, String name2, String[] stopWords) {
        this(matchVersion, name2);
        this.stopSet = StopFilter.makeStopSet(matchVersion, stopWords);
    }

    public SnowballAnalyzer(Version matchVersion, String name2, Set<?> stopWords) {
        this(matchVersion, name2);
        this.stopSet = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stopWords));
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result2 = new StandardTokenizer(this.matchVersion, reader);
        result2 = new StandardFilter(this.matchVersion, result2);
        if (this.matchVersion.onOrAfter(Version.LUCENE_31) && (this.name.equals("English") || this.name.equals("Porter") || this.name.equals("Lovins"))) {
            result2 = new EnglishPossessiveFilter(result2);
        }
        result2 = this.matchVersion.onOrAfter(Version.LUCENE_31) && this.name.equals("Turkish") ? new TurkishLowerCaseFilter(result2) : new LowerCaseFilter(this.matchVersion, result2);
        if (this.stopSet != null) {
            result2 = new StopFilter(this.matchVersion, result2, this.stopSet);
        }
        result2 = new SnowballFilter(result2, this.name);
        return result2;
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(this.matchVersion, reader);
            streams.result = new StandardFilter(this.matchVersion, streams.source);
            streams.result = this.matchVersion.onOrAfter(Version.LUCENE_31) && this.name.equals("Turkish") ? new TurkishLowerCaseFilter(streams.result) : new LowerCaseFilter(this.matchVersion, streams.result);
            if (this.stopSet != null) {
                streams.result = new StopFilter(this.matchVersion, streams.result, this.stopSet);
            }
            streams.result = new SnowballFilter(streams.result, this.name);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

