/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tr;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tr.TurkishLowerCaseFilter;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.TurkishStemmer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TurkishAnalyzer
extends StopwordAnalyzerBase {
    private final Set<?> stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private static final String STOPWORDS_COMMENT = "#";

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public TurkishAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public TurkishAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, CharArraySet.EMPTY_SET);
    }

    public TurkishAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionSet) {
        super(matchVersion, stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stemExclusionSet));
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source2 = new StandardTokenizer(this.matchVersion, reader);
        TokenFilter result2 = new StandardFilter(this.matchVersion, source2);
        result2 = new TurkishLowerCaseFilter(result2);
        result2 = new StopFilter(this.matchVersion, (TokenStream)result2, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result2 = new KeywordMarkerFilter((TokenStream)result2, this.stemExclusionSet);
        }
        result2 = new SnowballFilter((TokenStream)result2, new TurkishStemmer());
        return new ReusableAnalyzerBase.TokenStreamComponents(source2, result2);
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = TurkishAnalyzer.loadStopwordSet(false, TurkishAnalyzer.class, TurkishAnalyzer.DEFAULT_STOPWORD_FILE, TurkishAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

