/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

public class StemmerUtil {
    public static boolean startsWith(char[] s2, int len, String prefix) {
        int prefixLen = prefix.length();
        if (prefixLen > len) {
            return false;
        }
        for (int i2 = 0; i2 < prefixLen; ++i2) {
            if (s2[i2] == prefix.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(char[] s2, int len, String suffix) {
        int suffixLen = suffix.length();
        if (suffixLen > len) {
            return false;
        }
        for (int i2 = suffixLen - 1; i2 >= 0; --i2) {
            if (s2[len - (suffixLen - i2)] == suffix.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(char[] s2, int len, char[] suffix) {
        int suffixLen = suffix.length;
        if (suffixLen > len) {
            return false;
        }
        for (int i2 = suffixLen - 1; i2 >= 0; --i2) {
            if (s2[len - (suffixLen - i2)] == suffix[i2]) continue;
            return false;
        }
        return true;
    }

    public static int delete(char[] s2, int pos2, int len) {
        if (pos2 < len) {
            System.arraycopy(s2, pos2 + 1, s2, pos2, len - pos2 - 1);
        }
        return len - 1;
    }

    public static int deleteN(char[] s2, int pos2, int len, int nChars) {
        for (int i2 = 0; i2 < nChars; ++i2) {
            len = StemmerUtil.delete(s2, pos2, len);
        }
        return len;
    }
}

