/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFieldSelector
implements FieldSelector {
    Map<String, FieldSelectorResult> fieldSelections;

    public MapFieldSelector(Map<String, FieldSelectorResult> fieldSelections) {
        this.fieldSelections = fieldSelections;
    }

    public MapFieldSelector(List<String> fields2) {
        this.fieldSelections = new HashMap<String, FieldSelectorResult>(fields2.size() * 5 / 3);
        for (String field2 : fields2) {
            this.fieldSelections.put(field2, FieldSelectorResult.LOAD);
        }
    }

    public MapFieldSelector(String ... fields2) {
        this(Arrays.asList(fields2));
    }

    @Override
    public FieldSelectorResult accept(String field2) {
        FieldSelectorResult selection = this.fieldSelections.get(field2);
        return selection != null ? selection : FieldSelectorResult.NO_LOAD;
    }
}

