/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Serializable;
import org.apache.lucene.util.ArrayUtil;

public class Payload
implements Serializable,
Cloneable {
    protected byte[] data;
    protected int offset;
    protected int length;

    public Payload() {
    }

    public Payload(byte[] data2) {
        this(data2, 0, data2.length);
    }

    public Payload(byte[] data2, int offset2, int length2) {
        if (offset2 < 0 || offset2 + length2 > data2.length) {
            throw new IllegalArgumentException();
        }
        this.data = data2;
        this.offset = offset2;
        this.length = length2;
    }

    public void setData(byte[] data2) {
        this.setData(data2, 0, data2.length);
    }

    public void setData(byte[] data2, int offset2, int length2) {
        this.data = data2;
        this.offset = offset2;
        this.length = length2;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public byte byteAt(int index2) {
        if (0 <= index2 && index2 < this.length) {
            return this.data[this.offset + index2];
        }
        throw new ArrayIndexOutOfBoundsException(index2);
    }

    public byte[] toByteArray() {
        byte[] retArray = new byte[this.length];
        System.arraycopy(this.data, this.offset, retArray, 0, this.length);
        return retArray;
    }

    public void copyTo(byte[] target, int targetOffset) {
        if (this.length > target.length + targetOffset) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.data, this.offset, target, targetOffset, this.length);
    }

    public Object clone() {
        try {
            Payload clone = (Payload)super.clone();
            if (this.offset == 0 && this.length == this.data.length) {
                clone.data = (byte[])this.data.clone();
            } else {
                clone.data = this.toByteArray();
                clone.offset = 0;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Payload) {
            Payload other = (Payload)obj;
            if (this.length == other.length) {
                for (int i2 = 0; i2 < this.length; ++i2) {
                    if (this.data[this.offset + i2] == other.data[other.offset + i2]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return ArrayUtil.hashCode(this.data, this.offset, this.offset + this.length);
    }
}

