/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionBasedTermVectorMapper
extends TermVectorMapper {
    private Map<String, Map<Integer, TVPositionInfo>> fieldToTerms;
    private String currentField;
    private Map<Integer, TVPositionInfo> currentPositions;
    private boolean storeOffsets;

    public PositionBasedTermVectorMapper() {
        super(false, false);
    }

    public PositionBasedTermVectorMapper(boolean ignoringOffsets) {
        super(false, ignoringOffsets);
    }

    @Override
    public boolean isIgnoringPositions() {
        return false;
    }

    @Override
    public void map(String term, int frequency, TermVectorOffsetInfo[] offsets2, int[] positions) {
        for (int i2 = 0; i2 < positions.length; ++i2) {
            Integer posVal = positions[i2];
            TVPositionInfo pos2 = this.currentPositions.get(posVal);
            if (pos2 == null) {
                pos2 = new TVPositionInfo(positions[i2], this.storeOffsets);
                this.currentPositions.put(posVal, pos2);
            }
            pos2.addTerm(term, offsets2 != null ? offsets2[i2] : null);
        }
    }

    @Override
    public void setExpectations(String field2, int numTerms, boolean storeOffsets, boolean storePositions) {
        if (!storePositions) {
            throw new RuntimeException("You must store positions in order to use this Mapper");
        }
        if (storeOffsets) {
            // empty if block
        }
        this.fieldToTerms = new HashMap<String, Map<Integer, TVPositionInfo>>(numTerms);
        this.storeOffsets = storeOffsets;
        this.currentField = field2;
        this.currentPositions = new HashMap<Integer, TVPositionInfo>();
        this.fieldToTerms.put(this.currentField, this.currentPositions);
    }

    public Map<String, Map<Integer, TVPositionInfo>> getFieldToTerms() {
        return this.fieldToTerms;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TVPositionInfo {
        private int position;
        private List<String> terms;
        private List<TermVectorOffsetInfo> offsets;

        public TVPositionInfo(int position, boolean storeOffsets) {
            this.position = position;
            this.terms = new ArrayList<String>();
            if (storeOffsets) {
                this.offsets = new ArrayList<TermVectorOffsetInfo>();
            }
        }

        void addTerm(String term, TermVectorOffsetInfo info) {
            this.terms.add(term);
            if (this.offsets != null) {
                this.offsets.add(info);
            }
        }

        public int getPosition() {
            return this.position;
        }

        public List<String> getTerms() {
            return this.terms;
        }

        public List<TermVectorOffsetInfo> getOffsets() {
            return this.offsets;
        }
    }
}

