/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Arrays;
import org.apache.lucene.index.TermFreqVector;

class SegmentTermVector
implements TermFreqVector {
    private String field;
    private String[] terms;
    private int[] termFreqs;

    SegmentTermVector(String field2, String[] terms, int[] termFreqs) {
        this.field = field2;
        this.terms = terms;
        this.termFreqs = termFreqs;
    }

    public String getField() {
        return this.field;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append(this.field).append(": ");
        if (this.terms != null) {
            for (int i2 = 0; i2 < this.terms.length; ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(this.terms[i2]).append('/').append(this.termFreqs[i2]);
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public int size() {
        return this.terms == null ? 0 : this.terms.length;
    }

    public String[] getTerms() {
        return this.terms;
    }

    public int[] getTermFrequencies() {
        return this.termFreqs;
    }

    public int indexOf(String termText) {
        if (this.terms == null) {
            return -1;
        }
        int res = Arrays.binarySearch(this.terms, termText);
        return res >= 0 ? res : -1;
    }

    public int[] indexesOf(String[] termNumbers, int start2, int len) {
        int[] res = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            res[i2] = this.indexOf(termNumbers[start2 + i2]);
        }
        return res;
    }
}

