/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import org.apache.lucene.queryParser.FieldQueryExtension;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeFilter;
import org.elasticsearch.common.lucene.search.NotFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class MissingFieldQueryExtension
implements FieldQueryExtension {
    public static final String NAME = "_missing_";

    @Override
    public Query query(QueryParseContext parseContext, String queryText) {
        String fieldName = queryText;
        Filter filter = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            filter = smartNameFieldMappers.mapper().rangeFilter(null, null, true, true, parseContext);
        }
        if (filter == null) {
            filter = new TermRangeFilter(fieldName, null, null, true, true);
        }
        filter = parseContext.cacheFilter(filter, null);
        filter = new NotFilter(filter);
        filter = parseContext.cacheFilter(filter, null);
        filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
        return new DeletionAwareConstantScoreQuery(filter);
    }
}

