/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConjunctionScorer
extends Scorer {
    private final Scorer[] scorers;
    private int lastDoc = -1;

    public ConjunctionScorer(Weight weight, Collection<Scorer> scorers) throws IOException {
        this(weight, scorers.toArray(new Scorer[scorers.size()]));
    }

    public ConjunctionScorer(Weight weight, Scorer ... scorers) throws IOException {
        super(weight);
        this.scorers = scorers;
        for (int i2 = 0; i2 < scorers.length; ++i2) {
            if (scorers[i2].nextDoc() != Integer.MAX_VALUE) continue;
            this.lastDoc = Integer.MAX_VALUE;
            return;
        }
        ArrayUtil.mergeSort(scorers, new Comparator<Scorer>(){

            @Override
            public int compare(Scorer o1, Scorer o2) {
                return o1.docID() - o2.docID();
            }
        });
        if (this.doNext() == Integer.MAX_VALUE) {
            this.lastDoc = Integer.MAX_VALUE;
            return;
        }
        int end2 = scorers.length - 1;
        int max2 = end2 >> 1;
        for (int i3 = 0; i3 < max2; ++i3) {
            Scorer tmp = scorers[i3];
            int idx = end2 - i3 - 1;
            scorers[i3] = scorers[idx];
            scorers[idx] = tmp;
        }
    }

    private int doNext() throws IOException {
        Scorer firstScorer;
        int first2 = 0;
        int doc = this.scorers[this.scorers.length - 1].docID();
        while ((firstScorer = this.scorers[first2]).docID() < doc) {
            doc = firstScorer.advance(doc);
            first2 = first2 == this.scorers.length - 1 ? 0 : first2 + 1;
        }
        return doc;
    }

    @Override
    public int advance(int target) throws IOException {
        if (this.lastDoc == Integer.MAX_VALUE) {
            return this.lastDoc;
        }
        if (this.scorers[this.scorers.length - 1].docID() < target) {
            this.scorers[this.scorers.length - 1].advance(target);
        }
        this.lastDoc = this.doNext();
        return this.lastDoc;
    }

    @Override
    public int docID() {
        return this.lastDoc;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.lastDoc == Integer.MAX_VALUE) {
            return this.lastDoc;
        }
        if (this.lastDoc == -1) {
            this.lastDoc = this.scorers[this.scorers.length - 1].docID();
            return this.lastDoc;
        }
        this.scorers[this.scorers.length - 1].nextDoc();
        this.lastDoc = this.doNext();
        return this.lastDoc;
    }

    @Override
    public float score() throws IOException {
        float sum2 = 0.0f;
        for (int i2 = 0; i2 < this.scorers.length; ++i2) {
            sum2 += this.scorers[i2].score();
        }
        return sum2;
    }

    @Override
    public float freq() throws IOException {
        return this.scorers.length;
    }
}

