/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldValueHitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TopFieldCollector
extends TopDocsCollector<FieldValueHitQueue.Entry> {
    private static final ScoreDoc[] EMPTY_SCOREDOCS = new ScoreDoc[0];
    private final boolean fillFields;
    float maxScore = Float.NaN;
    final int numHits;
    FieldValueHitQueue.Entry bottom = null;
    boolean queueFull;
    int docBase;

    private TopFieldCollector(PriorityQueue<FieldValueHitQueue.Entry> pq, int numHits, boolean fillFields) {
        super(pq);
        this.numHits = numHits;
        this.fillFields = fillFields;
    }

    public static TopFieldCollector create(Sort sort2, int numHits, boolean fillFields, boolean trackDocScores, boolean trackMaxScore, boolean docsScoredInOrder) throws IOException {
        if (sort2.fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        FieldValueHitQueue<FieldValueHitQueue.Entry> queue = FieldValueHitQueue.create(sort2.fields, numHits);
        if (queue.getComparators().length == 1) {
            if (docsScoredInOrder) {
                if (trackMaxScore) {
                    return new OneComparatorScoringMaxScoreCollector(queue, numHits, fillFields);
                }
                if (trackDocScores) {
                    return new OneComparatorScoringNoMaxScoreCollector(queue, numHits, fillFields);
                }
                return new OneComparatorNonScoringCollector(queue, numHits, fillFields);
            }
            if (trackMaxScore) {
                return new OutOfOrderOneComparatorScoringMaxScoreCollector(queue, numHits, fillFields);
            }
            if (trackDocScores) {
                return new OutOfOrderOneComparatorScoringNoMaxScoreCollector(queue, numHits, fillFields);
            }
            return new OutOfOrderOneComparatorNonScoringCollector(queue, numHits, fillFields);
        }
        if (docsScoredInOrder) {
            if (trackMaxScore) {
                return new MultiComparatorScoringMaxScoreCollector(queue, numHits, fillFields);
            }
            if (trackDocScores) {
                return new MultiComparatorScoringNoMaxScoreCollector(queue, numHits, fillFields);
            }
            return new MultiComparatorNonScoringCollector(queue, numHits, fillFields);
        }
        if (trackMaxScore) {
            return new OutOfOrderMultiComparatorScoringMaxScoreCollector(queue, numHits, fillFields);
        }
        if (trackDocScores) {
            return new OutOfOrderMultiComparatorScoringNoMaxScoreCollector(queue, numHits, fillFields);
        }
        return new OutOfOrderMultiComparatorNonScoringCollector(queue, numHits, fillFields);
    }

    final void add(int slot, int doc, float score) {
        this.bottom = this.pq.add(new FieldValueHitQueue.Entry(slot, this.docBase + doc, score));
        this.queueFull = this.totalHits == this.numHits;
    }

    @Override
    protected void populateResults(ScoreDoc[] results, int howMany) {
        if (this.fillFields) {
            FieldValueHitQueue queue = (FieldValueHitQueue)this.pq;
            for (int i2 = howMany - 1; i2 >= 0; --i2) {
                results[i2] = queue.fillFields((FieldValueHitQueue.Entry)queue.pop());
            }
        } else {
            for (int i3 = howMany - 1; i3 >= 0; --i3) {
                FieldValueHitQueue.Entry entry = (FieldValueHitQueue.Entry)this.pq.pop();
                results[i3] = new FieldDoc(entry.doc, entry.score);
            }
        }
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start2) {
        if (results == null) {
            results = EMPTY_SCOREDOCS;
            this.maxScore = Float.NaN;
        }
        return new TopFieldDocs(this.totalHits, results, ((FieldValueHitQueue)this.pq).getFields(), this.maxScore);
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OutOfOrderMultiComparatorScoringNoMaxScoreCollector
    extends MultiComparatorScoringNoMaxScoreCollector {
        public OutOfOrderMultiComparatorScoringNoMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
        }

        @Override
        public void collect(int doc) throws IOException {
            block8: {
                block7: {
                    ++this.totalHits;
                    if (!this.queueFull) break block7;
                    int i2 = 0;
                    while (true) {
                        int c;
                        if ((c = this.reverseMul[i2] * this.comparators[i2].compareBottom(doc)) < 0) {
                            return;
                        }
                        if (c > 0) break;
                        if (i2 == this.comparators.length - 1) {
                            if (doc + this.docBase <= this.bottom.doc) break;
                            return;
                        }
                        ++i2;
                    }
                    for (i2 = 0; i2 < this.comparators.length; ++i2) {
                        this.comparators[i2].copy(this.bottom.slot, doc);
                    }
                    float score = this.scorer.score();
                    this.updateBottom(doc, score);
                    for (int i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].setBottom(this.bottom.slot);
                    }
                    break block8;
                }
                int slot = this.totalHits - 1;
                for (int i4 = 0; i4 < this.comparators.length; ++i4) {
                    this.comparators[i4].copy(slot, doc);
                }
                float score = this.scorer.score();
                this.add(slot, doc, score);
                if (!this.queueFull) break block8;
                for (int i5 = 0; i5 < this.comparators.length; ++i5) {
                    this.comparators[i5].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiComparatorScoringNoMaxScoreCollector
    extends MultiComparatorNonScoringCollector {
        Scorer scorer;

        public MultiComparatorScoringNoMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
        }

        final void updateBottom(int doc, float score) {
            this.bottom.doc = this.docBase + doc;
            this.bottom.score = score;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int doc) throws IOException {
            block8: {
                block7: {
                    ++this.totalHits;
                    if (!this.queueFull) break block7;
                    int i2 = 0;
                    while (true) {
                        int c;
                        if ((c = this.reverseMul[i2] * this.comparators[i2].compareBottom(doc)) < 0) {
                            return;
                        }
                        if (c > 0) break;
                        if (i2 == this.comparators.length - 1) {
                            return;
                        }
                        ++i2;
                    }
                    for (i2 = 0; i2 < this.comparators.length; ++i2) {
                        this.comparators[i2].copy(this.bottom.slot, doc);
                    }
                    float score = this.scorer.score();
                    this.updateBottom(doc, score);
                    for (int i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].setBottom(this.bottom.slot);
                    }
                    break block8;
                }
                int slot = this.totalHits - 1;
                for (int i4 = 0; i4 < this.comparators.length; ++i4) {
                    this.comparators[i4].copy(slot, doc);
                }
                float score = this.scorer.score();
                this.add(slot, doc, score);
                if (!this.queueFull) break block8;
                for (int i5 = 0; i5 < this.comparators.length; ++i5) {
                    this.comparators[i5].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OutOfOrderMultiComparatorScoringMaxScoreCollector
    extends MultiComparatorScoringMaxScoreCollector {
        public OutOfOrderMultiComparatorScoringMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
        }

        @Override
        public void collect(int doc) throws IOException {
            block9: {
                int i2;
                float score;
                block8: {
                    score = this.scorer.score();
                    if (score > this.maxScore) {
                        this.maxScore = score;
                    }
                    ++this.totalHits;
                    if (!this.queueFull) break block8;
                    int i3 = 0;
                    while (true) {
                        int c;
                        if ((c = this.reverseMul[i3] * this.comparators[i3].compareBottom(doc)) < 0) {
                            return;
                        }
                        if (c > 0) break;
                        if (i3 == this.comparators.length - 1) {
                            if (doc + this.docBase <= this.bottom.doc) break;
                            return;
                        }
                        ++i3;
                    }
                    for (i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].copy(this.bottom.slot, doc);
                    }
                    this.updateBottom(doc, score);
                    for (i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].setBottom(this.bottom.slot);
                    }
                    break block9;
                }
                int slot = this.totalHits - 1;
                for (i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2].copy(slot, doc);
                }
                this.add(slot, doc, score);
                if (!this.queueFull) break block9;
                for (i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiComparatorScoringMaxScoreCollector
    extends MultiComparatorNonScoringCollector {
        Scorer scorer;

        public MultiComparatorScoringMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
            this.maxScore = Float.NEGATIVE_INFINITY;
        }

        final void updateBottom(int doc, float score) {
            this.bottom.doc = this.docBase + doc;
            this.bottom.score = score;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int doc) throws IOException {
            block9: {
                int i2;
                float score;
                block8: {
                    score = this.scorer.score();
                    if (score > this.maxScore) {
                        this.maxScore = score;
                    }
                    ++this.totalHits;
                    if (!this.queueFull) break block8;
                    int i3 = 0;
                    while (true) {
                        int c;
                        if ((c = this.reverseMul[i3] * this.comparators[i3].compareBottom(doc)) < 0) {
                            return;
                        }
                        if (c > 0) break;
                        if (i3 == this.comparators.length - 1) {
                            return;
                        }
                        ++i3;
                    }
                    for (i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].copy(this.bottom.slot, doc);
                    }
                    this.updateBottom(doc, score);
                    for (i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].setBottom(this.bottom.slot);
                    }
                    break block9;
                }
                int slot = this.totalHits - 1;
                for (i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2].copy(slot, doc);
                }
                this.add(slot, doc, score);
                if (!this.queueFull) break block9;
                for (i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutOfOrderMultiComparatorNonScoringCollector
    extends MultiComparatorNonScoringCollector {
        public OutOfOrderMultiComparatorNonScoringCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
        }

        @Override
        public void collect(int doc) throws IOException {
            block8: {
                int i2;
                block7: {
                    ++this.totalHits;
                    if (!this.queueFull) break block7;
                    int i3 = 0;
                    while (true) {
                        int c;
                        if ((c = this.reverseMul[i3] * this.comparators[i3].compareBottom(doc)) < 0) {
                            return;
                        }
                        if (c > 0) break;
                        if (i3 == this.comparators.length - 1) {
                            if (doc + this.docBase <= this.bottom.doc) break;
                            return;
                        }
                        ++i3;
                    }
                    for (i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].copy(this.bottom.slot, doc);
                    }
                    this.updateBottom(doc);
                    for (i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].setBottom(this.bottom.slot);
                    }
                    break block8;
                }
                int slot = this.totalHits - 1;
                for (i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2].copy(slot, doc);
                }
                this.add(slot, doc, Float.NaN);
                if (!this.queueFull) break block8;
                for (i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiComparatorNonScoringCollector
    extends TopFieldCollector {
        final FieldComparator<?>[] comparators;
        final int[] reverseMul;

        public MultiComparatorNonScoringCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
            this.comparators = queue.getComparators();
            this.reverseMul = queue.getReverseMul();
        }

        final void updateBottom(int doc) {
            this.bottom.doc = this.docBase + doc;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int doc) throws IOException {
            block8: {
                int i2;
                block7: {
                    ++this.totalHits;
                    if (!this.queueFull) break block7;
                    int i3 = 0;
                    while (true) {
                        int c;
                        if ((c = this.reverseMul[i3] * this.comparators[i3].compareBottom(doc)) < 0) {
                            return;
                        }
                        if (c > 0) break;
                        if (i3 == this.comparators.length - 1) {
                            return;
                        }
                        ++i3;
                    }
                    for (i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].copy(this.bottom.slot, doc);
                    }
                    this.updateBottom(doc);
                    for (i3 = 0; i3 < this.comparators.length; ++i3) {
                        this.comparators[i3].setBottom(this.bottom.slot);
                    }
                    break block8;
                }
                int slot = this.totalHits - 1;
                for (i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2].copy(slot, doc);
                }
                this.add(slot, doc, Float.NaN);
                if (!this.queueFull) break block8;
                for (i2 = 0; i2 < this.comparators.length; ++i2) {
                    this.comparators[i2].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.docBase = docBase;
            for (int i2 = 0; i2 < this.comparators.length; ++i2) {
                this.comparators[i2].setNextReader(reader, docBase);
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            for (int i2 = 0; i2 < this.comparators.length; ++i2) {
                this.comparators[i2].setScorer(scorer);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutOfOrderOneComparatorScoringMaxScoreCollector
    extends OneComparatorScoringMaxScoreCollector {
        public OutOfOrderOneComparatorScoringMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
        }

        @Override
        public void collect(int doc) throws IOException {
            float score = this.scorer.score();
            if (score > this.maxScore) {
                this.maxScore = score;
            }
            ++this.totalHits;
            if (this.queueFull) {
                int cmp2 = this.reverseMul * this.comparator.compareBottom(doc);
                if (cmp2 < 0 || cmp2 == 0 && doc + this.docBase > this.bottom.doc) {
                    return;
                }
                this.comparator.copy(this.bottom.slot, doc);
                this.updateBottom(doc, score);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                int slot = this.totalHits - 1;
                this.comparator.copy(slot, doc);
                this.add(slot, doc, score);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneComparatorScoringMaxScoreCollector
    extends OneComparatorNonScoringCollector {
        Scorer scorer;

        public OneComparatorScoringMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
            this.maxScore = Float.NEGATIVE_INFINITY;
        }

        final void updateBottom(int doc, float score) {
            this.bottom.doc = this.docBase + doc;
            this.bottom.score = score;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int doc) throws IOException {
            float score = this.scorer.score();
            if (score > this.maxScore) {
                this.maxScore = score;
            }
            ++this.totalHits;
            if (this.queueFull) {
                if (this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                    return;
                }
                this.comparator.copy(this.bottom.slot, doc);
                this.updateBottom(doc, score);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                int slot = this.totalHits - 1;
                this.comparator.copy(slot, doc);
                this.add(slot, doc, score);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutOfOrderOneComparatorScoringNoMaxScoreCollector
    extends OneComparatorScoringNoMaxScoreCollector {
        public OutOfOrderOneComparatorScoringNoMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
        }

        @Override
        public void collect(int doc) throws IOException {
            ++this.totalHits;
            if (this.queueFull) {
                int cmp2 = this.reverseMul * this.comparator.compareBottom(doc);
                if (cmp2 < 0 || cmp2 == 0 && doc + this.docBase > this.bottom.doc) {
                    return;
                }
                float score = this.scorer.score();
                this.comparator.copy(this.bottom.slot, doc);
                this.updateBottom(doc, score);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                float score = this.scorer.score();
                int slot = this.totalHits - 1;
                this.comparator.copy(slot, doc);
                this.add(slot, doc, score);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneComparatorScoringNoMaxScoreCollector
    extends OneComparatorNonScoringCollector {
        Scorer scorer;

        public OneComparatorScoringNoMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
        }

        final void updateBottom(int doc, float score) {
            this.bottom.doc = this.docBase + doc;
            this.bottom.score = score;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int doc) throws IOException {
            ++this.totalHits;
            if (this.queueFull) {
                if (this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                    return;
                }
                float score = this.scorer.score();
                this.comparator.copy(this.bottom.slot, doc);
                this.updateBottom(doc, score);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                float score = this.scorer.score();
                int slot = this.totalHits - 1;
                this.comparator.copy(slot, doc);
                this.add(slot, doc, score);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            this.comparator.setScorer(scorer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutOfOrderOneComparatorNonScoringCollector
    extends OneComparatorNonScoringCollector {
        public OutOfOrderOneComparatorNonScoringCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
        }

        @Override
        public void collect(int doc) throws IOException {
            ++this.totalHits;
            if (this.queueFull) {
                int cmp2 = this.reverseMul * this.comparator.compareBottom(doc);
                if (cmp2 < 0 || cmp2 == 0 && doc + this.docBase > this.bottom.doc) {
                    return;
                }
                this.comparator.copy(this.bottom.slot, doc);
                this.updateBottom(doc);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                int slot = this.totalHits - 1;
                this.comparator.copy(slot, doc);
                this.add(slot, doc, Float.NaN);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneComparatorNonScoringCollector
    extends TopFieldCollector {
        final FieldComparator<?> comparator;
        final int reverseMul;

        public OneComparatorNonScoringCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, boolean fillFields) throws IOException {
            super(queue, numHits, fillFields);
            this.comparator = queue.getComparators()[0];
            this.reverseMul = queue.getReverseMul()[0];
        }

        final void updateBottom(int doc) {
            this.bottom.doc = this.docBase + doc;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int doc) throws IOException {
            ++this.totalHits;
            if (this.queueFull) {
                if (this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                    return;
                }
                this.comparator.copy(this.bottom.slot, doc);
                this.updateBottom(doc);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                int slot = this.totalHits - 1;
                this.comparator.copy(slot, doc);
                this.add(slot, doc, Float.NaN);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.docBase = docBase;
            this.comparator.setNextReader(reader, docBase);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.comparator.setScorer(scorer);
        }
    }
}

