/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.FixedBitSet;

public class XTermsFilter
extends Filter {
    private final Term[] terms;

    public XTermsFilter(Term term) {
        this.terms = new Term[]{term};
    }

    public XTermsFilter(Term[] terms) {
        Arrays.sort(terms);
        this.terms = terms;
    }

    public Term[] getTerms() {
        return this.terms;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        XTermsFilter test2 = (XTermsFilter)obj;
        return Arrays.equals(this.terms, test2.terms);
    }

    public int hashCode() {
        return Arrays.hashCode(this.terms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        FixedBitSet result2 = null;
        TermDocs td = reader.termDocs();
        try {
            int[] docs = new int[32];
            int[] freqs = new int[32];
            for (Term term : this.terms) {
                td.seek(term);
                int number = td.read(docs, freqs);
                if (number <= 0) continue;
                if (result2 == null) {
                    result2 = new FixedBitSet(reader.maxDoc());
                }
                while (number > 0) {
                    for (int i2 = 0; i2 < number; ++i2) {
                        result2.set(docs[i2]);
                    }
                    number = td.read(docs, freqs);
                }
            }
        }
        finally {
            td.close();
        }
        return result2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Term term : this.terms) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(term);
        }
        return builder.toString();
    }
}

