/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import org.apache.lucene.search.function.ByteFieldSource;
import org.apache.lucene.search.function.FloatFieldSource;
import org.apache.lucene.search.function.IntFieldSource;
import org.apache.lucene.search.function.ShortFieldSource;
import org.apache.lucene.search.function.ValueSource;
import org.apache.lucene.search.function.ValueSourceQuery;

public class FieldScoreQuery
extends ValueSourceQuery {
    public FieldScoreQuery(String field2, Type type2) {
        super(FieldScoreQuery.getValueSource(field2, type2));
    }

    private static ValueSource getValueSource(String field2, Type type2) {
        if (type2 == Type.BYTE) {
            return new ByteFieldSource(field2);
        }
        if (type2 == Type.SHORT) {
            return new ShortFieldSource(field2);
        }
        if (type2 == Type.INT) {
            return new IntFieldSource(field2);
        }
        if (type2 == Type.FLOAT) {
            return new FloatFieldSource(field2);
        }
        throw new IllegalArgumentException(type2 + " is not a known Field Score Query Type!");
    }

    public static class Type {
        public static final Type BYTE = new Type("byte");
        public static final Type SHORT = new Type("short");
        public static final Type INT = new Type("int");
        public static final Type FLOAT = new Type("float");
        private String typeName;

        private Type(String name2) {
            this.typeName = name2;
        }

        public String toString() {
            return this.getClass().getName() + "::" + this.typeName;
        }
    }
}

