/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import org.apache.lucene.search.highlight.Encoder;

public class SimpleHTMLEncoder
implements Encoder {
    public String encodeText(String originalText) {
        return SimpleHTMLEncoder.htmlEncode(originalText);
    }

    public static final String htmlEncode(String plainText) {
        if (plainText == null || plainText.length() == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder(plainText.length());
        block6: for (int index2 = 0; index2 < plainText.length(); ++index2) {
            char ch = plainText.charAt(index2);
            switch (ch) {
                case '\"': {
                    result2.append("&quot;");
                    continue block6;
                }
                case '&': {
                    result2.append("&amp;");
                    continue block6;
                }
                case '<': {
                    result2.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result2.append("&gt;");
                    continue block6;
                }
                default: {
                    if (ch < '\u0080') {
                        result2.append(ch);
                        continue block6;
                    }
                    result2.append("&#").append((int)ch).append(";");
                }
            }
        }
        return result2.toString();
    }
}

