/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.Spans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadSpanUtil {
    private IndexReader reader;

    public PayloadSpanUtil(IndexReader reader) {
        this.reader = reader;
    }

    public Collection<byte[]> getPayloadsForQuery(Query query) throws IOException {
        ArrayList<byte[]> payloads = new ArrayList<byte[]>();
        this.queryToSpanQuery(query, payloads);
        return payloads;
    }

    private void queryToSpanQuery(Query query, Collection<byte[]> payloads) throws IOException {
        if (query instanceof BooleanQuery) {
            BooleanClause[] queryClauses = ((BooleanQuery)query).getClauses();
            for (int i2 = 0; i2 < queryClauses.length; ++i2) {
                if (queryClauses[i2].isProhibited()) continue;
                this.queryToSpanQuery(queryClauses[i2].getQuery(), payloads);
            }
        } else if (query instanceof PhraseQuery) {
            Term[] phraseQueryTerms = ((PhraseQuery)query).getTerms();
            SpanQuery[] clauses = new SpanQuery[phraseQueryTerms.length];
            for (int i3 = 0; i3 < phraseQueryTerms.length; ++i3) {
                clauses[i3] = new SpanTermQuery(phraseQueryTerms[i3]);
            }
            int slop = ((PhraseQuery)query).getSlop();
            boolean inorder = false;
            if (slop == 0) {
                inorder = true;
            }
            SpanNearQuery sp = new SpanNearQuery(clauses, slop, inorder);
            sp.setBoost(query.getBoost());
            this.getPayloads(payloads, sp);
        } else if (query instanceof TermQuery) {
            SpanTermQuery stq = new SpanTermQuery(((TermQuery)query).getTerm());
            stq.setBoost(query.getBoost());
            this.getPayloads(payloads, stq);
        } else if (query instanceof SpanQuery) {
            this.getPayloads(payloads, (SpanQuery)query);
        } else if (query instanceof FilteredQuery) {
            this.queryToSpanQuery(((FilteredQuery)query).getQuery(), payloads);
        } else if (query instanceof DisjunctionMaxQuery) {
            Iterator<Query> iterator = ((DisjunctionMaxQuery)query).iterator();
            while (iterator.hasNext()) {
                this.queryToSpanQuery(iterator.next(), payloads);
            }
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)query;
            List<Term[]> termArrays = mpq.getTermArrays();
            int[] positions = mpq.getPositions();
            if (positions.length > 0) {
                int maxPosition = positions[positions.length - 1];
                for (int i4 = 0; i4 < positions.length - 1; ++i4) {
                    if (positions[i4] <= maxPosition) continue;
                    maxPosition = positions[i4];
                }
                List[] disjunctLists = new List[maxPosition + 1];
                int distinctPositions = 0;
                for (int i5 = 0; i5 < termArrays.size(); ++i5) {
                    Term[] termArray = termArrays.get(i5);
                    ArrayList<SpanTermQuery> disjuncts = disjunctLists[positions[i5]];
                    if (disjuncts == null) {
                        ArrayList<SpanTermQuery> arrayList = new ArrayList<SpanTermQuery>(termArray.length);
                        disjunctLists[positions[i5]] = arrayList;
                        disjuncts = arrayList;
                        ++distinctPositions;
                    }
                    for (Term term : termArray) {
                        disjuncts.add(new SpanTermQuery(term));
                    }
                }
                int positionGaps = 0;
                int position = 0;
                SpanQuery[] clauses = new SpanQuery[distinctPositions];
                for (int i6 = 0; i6 < disjunctLists.length; ++i6) {
                    List disjuncts = disjunctLists[i6];
                    if (disjuncts != null) {
                        clauses[position++] = new SpanOrQuery(disjuncts.toArray(new SpanQuery[disjuncts.size()]));
                        continue;
                    }
                    ++positionGaps;
                }
                int slop = mpq.getSlop();
                boolean inorder = slop == 0;
                SpanNearQuery sp = new SpanNearQuery(clauses, slop + positionGaps, inorder);
                sp.setBoost(query.getBoost());
                this.getPayloads(payloads, sp);
            }
        }
    }

    private void getPayloads(Collection<byte[]> payloads, SpanQuery query) throws IOException {
        Spans spans = query.getSpans(this.reader);
        while (spans.next()) {
            if (!spans.isPayloadAvailable()) continue;
            Collection<byte[]> payload = spans.getPayload();
            for (byte[] bytes2 : payload) {
                payloads.add(bytes2);
            }
        }
    }
}

