/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similar;

import java.io.IOException;
import java.io.StringReader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similar.MoreLikeThis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoreLikeThisQuery
extends Query {
    private String likeText;
    private String[] moreLikeFields;
    private Analyzer analyzer;
    private String fieldName;
    private float percentTermsToMatch = 0.3f;
    private int minTermFrequency = 1;
    private int maxQueryTerms = 5;
    private Set<?> stopWords = null;
    private int minDocFreq = -1;

    @Deprecated
    public MoreLikeThisQuery(String likeText, String[] moreLikeFields, Analyzer analyzer) {
        this(likeText, moreLikeFields, analyzer, moreLikeFields[0]);
    }

    public MoreLikeThisQuery(String likeText, String[] moreLikeFields, Analyzer analyzer, String fieldName) {
        this.likeText = likeText;
        this.moreLikeFields = moreLikeFields;
        this.analyzer = analyzer;
        this.fieldName = fieldName;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        MoreLikeThis mlt = new MoreLikeThis(reader);
        mlt.setFieldNames(this.moreLikeFields);
        mlt.setAnalyzer(this.analyzer);
        mlt.setMinTermFreq(this.minTermFrequency);
        if (this.minDocFreq >= 0) {
            mlt.setMinDocFreq(this.minDocFreq);
        }
        mlt.setMaxQueryTerms(this.maxQueryTerms);
        mlt.setStopWords(this.stopWords);
        BooleanQuery bq = (BooleanQuery)mlt.like(new StringReader(this.likeText), this.fieldName);
        BooleanClause[] clauses = bq.getClauses();
        bq.setMinimumNumberShouldMatch((int)((float)clauses.length * this.percentTermsToMatch));
        return bq;
    }

    @Override
    public String toString(String field2) {
        return "like:" + this.likeText;
    }

    public float getPercentTermsToMatch() {
        return this.percentTermsToMatch;
    }

    public void setPercentTermsToMatch(float percentTermsToMatch) {
        this.percentTermsToMatch = percentTermsToMatch;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public String getLikeText() {
        return this.likeText;
    }

    public void setLikeText(String likeText) {
        this.likeText = likeText;
    }

    public int getMaxQueryTerms() {
        return this.maxQueryTerms;
    }

    public void setMaxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
    }

    public int getMinTermFrequency() {
        return this.minTermFrequency;
    }

    public void setMinTermFrequency(int minTermFrequency) {
        this.minTermFrequency = minTermFrequency;
    }

    public String[] getMoreLikeFields() {
        return this.moreLikeFields;
    }

    public void setMoreLikeFields(String[] moreLikeFields) {
        this.moreLikeFields = moreLikeFields;
    }

    public Set<?> getStopWords() {
        return this.stopWords;
    }

    public void setStopWords(Set<?> stopWords) {
        this.stopWords = stopWords;
    }

    public int getMinDocFreq() {
        return this.minDocFreq;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }
}

