/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;

public class FieldTermStack {
    private final String fieldName;
    LinkedList<TermInfo> termList = new LinkedList();

    public static void main(String[] args2) throws Exception {
        WhitespaceAnalyzer analyzer = new WhitespaceAnalyzer(Version.LUCENE_CURRENT);
        QueryParser parser = new QueryParser(Version.LUCENE_CURRENT, "f", analyzer);
        Query query = parser.parse("a x:b");
        FieldQuery fieldQuery = new FieldQuery(query, true, false);
        RAMDirectory dir = new RAMDirectory();
        IndexWriter writer = new IndexWriter(dir, new IndexWriterConfig(Version.LUCENE_CURRENT, analyzer));
        Document doc = new Document();
        doc.add(new Field("f", "a a a b b c a b b c d e f", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        doc.add(new Field("f", "b a b a f", Field.Store.YES, Field.Index.ANALYZED, Field.TermVector.WITH_POSITIONS_OFFSETS));
        writer.addDocument(doc);
        writer.close();
        IndexReader reader = IndexReader.open((Directory)dir, true);
        new FieldTermStack(reader, 0, "f", fieldQuery);
        reader.close();
    }

    public FieldTermStack(IndexReader reader, int docId, String fieldName, FieldQuery fieldQuery) throws IOException {
        this.fieldName = fieldName;
        Set<String> termSet = fieldQuery.getTermSet(fieldName);
        if (termSet == null) {
            return;
        }
        TermFreqVector tfv = reader.getTermFreqVector(docId, fieldName);
        if (tfv == null) {
            return;
        }
        TermPositionVector tpv = null;
        try {
            tpv = (TermPositionVector)tfv;
        }
        catch (ClassCastException e) {
            return;
        }
        for (String term : tpv.getTerms()) {
            if (!termSet.contains(term)) continue;
            int index2 = tpv.indexOf(term);
            TermVectorOffsetInfo[] tvois = tpv.getOffsets(index2);
            if (tvois == null) {
                return;
            }
            int[] poss = tpv.getTermPositions(index2);
            if (poss == null) {
                return;
            }
            for (int i2 = 0; i2 < tvois.length; ++i2) {
                this.termList.add(new TermInfo(term, tvois[i2].getStartOffset(), tvois[i2].getEndOffset(), poss[i2]));
            }
        }
        Collections.sort(this.termList);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public TermInfo pop() {
        return this.termList.poll();
    }

    public void push(TermInfo termInfo) {
        this.termList.addFirst(termInfo);
    }

    public boolean isEmpty() {
        return this.termList == null || this.termList.size() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TermInfo
    implements Comparable<TermInfo> {
        final String text;
        final int startOffset;
        final int endOffset;
        final int position;

        TermInfo(String text, int startOffset, int endOffset, int position) {
            this.text = text;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.position = position;
        }

        public String getText() {
            return this.text;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getPosition() {
            return this.position;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.text).append('(').append(this.startOffset).append(',').append(this.endOffset).append(',').append(this.position).append(')');
            return sb.toString();
        }

        @Override
        public int compareTo(TermInfo o) {
            return this.position - o.position;
        }
    }
}

