/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;

public final class ByteArrayDataInput
extends DataInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataInput(byte[] bytes2) {
        this.reset(bytes2);
    }

    public ByteArrayDataInput(byte[] bytes2, int offset2, int len) {
        this.reset(bytes2, offset2, len);
    }

    public ByteArrayDataInput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] bytes2) {
        this.reset(bytes2, 0, bytes2.length);
    }

    public int getPosition() {
        return this.pos;
    }

    public void reset(byte[] bytes2, int offset2, int len) {
        this.bytes = bytes2;
        this.pos = offset2;
        this.limit = offset2 + len;
    }

    public boolean eof() {
        return this.pos == this.limit;
    }

    public void skipBytes(int count2) {
        this.pos += count2;
    }

    public short readShort() {
        return (short)((this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF);
    }

    public int readInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    public long readLong() {
        int i1 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        int i2 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    public int readVInt() {
        byte b = this.bytes[this.pos++];
        int i2 = b & 0x7F;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= (b & 0xF) << 28;
        if ((b & 0xF0) == 0) {
            return i2;
        }
        throw new RuntimeException("Invalid vInt detected (too many bits)");
    }

    public long readVLong() {
        byte b = this.bytes[this.pos++];
        long i2 = (long)b & 0x7FL;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= ((long)b & 0x7FL) << 7;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= ((long)b & 0x7FL) << 14;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= ((long)b & 0x7FL) << 21;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= ((long)b & 0x7FL) << 28;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= ((long)b & 0x7FL) << 35;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= ((long)b & 0x7FL) << 42;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= ((long)b & 0x7FL) << 49;
        if ((b & 0x80) == 0) {
            return i2;
        }
        b = this.bytes[this.pos++];
        i2 |= ((long)b & 0x7FL) << 56;
        if ((b & 0x80) == 0) {
            return i2;
        }
        throw new RuntimeException("Invalid vLong detected (negative values disallowed)");
    }

    public byte readByte() {
        return this.bytes[this.pos++];
    }

    public void readBytes(byte[] b, int offset2, int len) {
        System.arraycopy(this.bytes, this.pos, b, offset2, len);
        this.pos += len;
    }
}

