/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.BytesRef;

public class ByteArrayDataOutput
extends DataOutput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataOutput(byte[] bytes2) {
        this.reset(bytes2);
    }

    public ByteArrayDataOutput(byte[] bytes2, int offset2, int len) {
        this.reset(bytes2, offset2, len);
    }

    public ByteArrayDataOutput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] bytes2) {
        this.reset(bytes2, 0, bytes2.length);
    }

    public void reset(byte[] bytes2, int offset2, int len) {
        this.bytes = bytes2;
        this.pos = offset2;
        this.limit = offset2 + len;
    }

    public int getPosition() {
        return this.pos;
    }

    public void writeByte(byte b) {
        assert (this.pos < this.limit);
        this.bytes[this.pos++] = b;
    }

    public void writeBytes(byte[] b, int offset2, int length2) {
        assert (this.pos + length2 <= this.limit);
        System.arraycopy(b, offset2, this.bytes, this.pos, length2);
        this.pos += length2;
    }
}

