/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.IndexOutput;

public class ChecksumIndexOutput
extends IndexOutput {
    IndexOutput main;
    Checksum digest;

    public ChecksumIndexOutput(IndexOutput main2) {
        this.main = main2;
        this.digest = new CRC32();
    }

    public void writeByte(byte b) throws IOException {
        this.digest.update(b);
        this.main.writeByte(b);
    }

    public void writeBytes(byte[] b, int offset2, int length2) throws IOException {
        this.digest.update(b, offset2, length2);
        this.main.writeBytes(b, offset2, length2);
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    public void flush() throws IOException {
        this.main.flush();
    }

    public void close() throws IOException {
        this.main.close();
    }

    public long getFilePointer() {
        return this.main.getFilePointer();
    }

    public void seek(long pos2) {
        throw new UnsupportedOperationException();
    }

    public void prepareCommit() throws IOException {
        long checksum = this.getChecksum();
        long pos2 = this.main.getFilePointer();
        this.main.writeLong(checksum - 1L);
        this.main.flush();
        this.main.seek(pos2);
    }

    public void finishCommit() throws IOException {
        this.main.writeLong(this.getChecksum());
    }

    public long length() throws IOException {
        return this.main.length();
    }
}

