/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;

public abstract class OpenBufferedIndexOutput
extends IndexOutput {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    final int BUFFER_SIZE;
    private final byte[] buffer;
    private long bufferStart = 0L;
    private int bufferPosition = 0;

    protected OpenBufferedIndexOutput(int BUFFER_SIZE) {
        this.BUFFER_SIZE = BUFFER_SIZE;
        this.buffer = new byte[BUFFER_SIZE];
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition >= this.BUFFER_SIZE) {
            this.flush();
        }
        this.buffer[this.bufferPosition++] = b;
    }

    @Override
    public void writeBytes(byte[] b, int offset2, int length2) throws IOException {
        int bytesLeft = this.BUFFER_SIZE - this.bufferPosition;
        if (bytesLeft >= length2) {
            System.arraycopy(b, offset2, this.buffer, this.bufferPosition, length2);
            this.bufferPosition += length2;
            if (this.BUFFER_SIZE - this.bufferPosition == 0) {
                this.flush();
            }
        } else if (length2 > this.BUFFER_SIZE) {
            if (this.bufferPosition > 0) {
                this.flush();
            }
            this.flushBuffer(b, offset2, length2);
            this.bufferStart += (long)length2;
        } else {
            int pos2 = 0;
            while (pos2 < length2) {
                int pieceLength = length2 - pos2 < bytesLeft ? length2 - pos2 : bytesLeft;
                System.arraycopy(b, pos2 + offset2, this.buffer, this.bufferPosition, pieceLength);
                pos2 += pieceLength;
                this.bufferPosition += pieceLength;
                bytesLeft = this.BUFFER_SIZE - this.bufferPosition;
                if (bytesLeft != 0) continue;
                this.flush();
                bytesLeft = this.BUFFER_SIZE;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer(this.buffer, this.bufferPosition);
        this.bufferStart += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    private void flushBuffer(byte[] b, int len) throws IOException {
        this.flushBuffer(b, 0, len);
    }

    protected abstract void flushBuffer(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public void seek(long pos2) throws IOException {
        this.flush();
        this.bufferStart = pos2;
    }

    @Override
    public abstract long length() throws IOException;
}

