/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.util.ThreadInterruptedException;

public class RAMDirectory
extends Directory
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Map<String, RAMFile> fileMap = new ConcurrentHashMap<String, RAMFile>();
    protected final AtomicLong sizeInBytes = new AtomicLong();

    public RAMDirectory() {
        try {
            this.setLockFactory(new SingleInstanceLockFactory());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public RAMDirectory(Directory dir) throws IOException {
        this(dir, false);
    }

    private RAMDirectory(Directory dir, boolean closeDir) throws IOException {
        this();
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        for (String file2 : dir.listAll()) {
            if (!filter.accept(null, file2)) continue;
            dir.copy(this, file2, file2);
        }
        if (closeDir) {
            dir.close();
        }
    }

    public final String[] listAll() {
        this.ensureOpen();
        Set<String> fileNames = this.fileMap.keySet();
        ArrayList<String> names2 = new ArrayList<String>(fileNames.size());
        for (String name2 : fileNames) {
            names2.add(name2);
        }
        return names2.toArray(new String[names2.size()]);
    }

    public final boolean fileExists(String name2) {
        this.ensureOpen();
        return this.fileMap.containsKey(name2);
    }

    public final long fileModified(String name2) throws IOException {
        this.ensureOpen();
        RAMFile file2 = this.fileMap.get(name2);
        if (file2 == null) {
            throw new FileNotFoundException(name2);
        }
        return file2.getLastModified();
    }

    @Deprecated
    public void touchFile(String name2) throws IOException {
        long ts2;
        this.ensureOpen();
        RAMFile file2 = this.fileMap.get(name2);
        if (file2 == null) {
            throw new FileNotFoundException(name2);
        }
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException ie) {
                throw new ThreadInterruptedException(ie);
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file2.setLastModified(ts2);
    }

    public final long fileLength(String name2) throws IOException {
        this.ensureOpen();
        RAMFile file2 = this.fileMap.get(name2);
        if (file2 == null) {
            throw new FileNotFoundException(name2);
        }
        return file2.getLength();
    }

    public final long sizeInBytes() {
        this.ensureOpen();
        return this.sizeInBytes.get();
    }

    public void deleteFile(String name2) throws IOException {
        this.ensureOpen();
        RAMFile file2 = this.fileMap.remove(name2);
        if (file2 == null) {
            throw new FileNotFoundException(name2);
        }
        file2.directory = null;
        this.sizeInBytes.addAndGet(-file2.sizeInBytes);
    }

    public IndexOutput createOutput(String name2) throws IOException {
        this.ensureOpen();
        RAMFile file2 = this.newRAMFile();
        RAMFile existing = this.fileMap.remove(name2);
        if (existing != null) {
            this.sizeInBytes.addAndGet(-existing.sizeInBytes);
            existing.directory = null;
        }
        this.fileMap.put(name2, file2);
        return new RAMOutputStream(file2);
    }

    protected RAMFile newRAMFile() {
        return new RAMFile(this);
    }

    public IndexInput openInput(String name2) throws IOException {
        this.ensureOpen();
        RAMFile file2 = this.fileMap.get(name2);
        if (file2 == null) {
            throw new FileNotFoundException(name2);
        }
        return new RAMInputStream(name2, file2);
    }

    public void close() {
        this.isOpen = false;
        this.fileMap.clear();
    }
}

