/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;

public class SimpleFSDirectory
extends FSDirectory {
    public SimpleFSDirectory(File path2, LockFactory lockFactory) throws IOException {
        super(path2, lockFactory);
    }

    public SimpleFSDirectory(File path2) throws IOException {
        super(path2, null);
    }

    public IndexInput openInput(String name2, int bufferSize) throws IOException {
        this.ensureOpen();
        File path2 = new File(this.directory, name2);
        return new SimpleFSIndexInput("SimpleFSIndexInput(path=\"" + path2.getPath() + "\")", path2, bufferSize, this.getReadChunkSize());
    }

    protected static class SimpleFSIndexInput
    extends BufferedIndexInput {
        protected final Descriptor file;
        boolean isClone;
        protected final int chunkSize;

        @Deprecated
        public SimpleFSIndexInput(File path2, int bufferSize, int chunkSize) throws IOException {
            this("anonymous SimpleFSIndexInput", path2, bufferSize, chunkSize);
        }

        public SimpleFSIndexInput(String resourceDesc, File path2, int bufferSize, int chunkSize) throws IOException {
            super(resourceDesc, bufferSize);
            this.file = new Descriptor(path2, "r");
            this.chunkSize = chunkSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readInternal(byte[] b, int offset2, int len) throws IOException {
            Descriptor descriptor = this.file;
            synchronized (descriptor) {
                long position = this.getFilePointer();
                if (position != this.file.position) {
                    this.file.seek(position);
                    this.file.position = position;
                }
                int total2 = 0;
                try {
                    int i2;
                    do {
                        int readLength;
                        if ((i2 = this.file.read(b, offset2 + total2, readLength = total2 + this.chunkSize > len ? len - total2 : this.chunkSize)) == -1) {
                            throw new EOFException("read past EOF: " + this);
                        }
                        this.file.position += (long)i2;
                    } while ((total2 += i2) < len);
                }
                catch (OutOfMemoryError e) {
                    OutOfMemoryError outOfMemoryError = new OutOfMemoryError("OutOfMemoryError likely caused by the Sun VM Bug described in https://issues.apache.org/jira/browse/LUCENE-1566; try calling FSDirectory.setReadChunkSize with a value smaller than the current chunk size (" + this.chunkSize + ")");
                    outOfMemoryError.initCause(e);
                    throw outOfMemoryError;
                }
                catch (IOException ioe) {
                    IOException newIOE = new IOException(ioe.getMessage() + ": " + this);
                    newIOE.initCause(ioe);
                    throw newIOE;
                }
            }
        }

        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        protected void seekInternal(long position) {
        }

        public long length() {
            return this.file.length;
        }

        public Object clone() {
            SimpleFSIndexInput clone = (SimpleFSIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        boolean isFDValid() throws IOException {
            return this.file.getFD().valid();
        }

        public void copyBytes(IndexOutput out, long numBytes) throws IOException {
            numBytes -= (long)this.flushBuffer(out, numBytes);
            out.copyBytes(this, numBytes);
        }

        protected static class Descriptor
        extends RandomAccessFile {
            protected volatile boolean isOpen = true;
            long position;
            final long length = this.length();

            public Descriptor(File file2, String mode2) throws IOException {
                super(file2, mode2);
            }

            public void close() throws IOException {
                if (this.isOpen) {
                    this.isOpen = false;
                    super.close();
                }
            }
        }
    }
}

