/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.RateLimiter;
import org.elasticsearch.common.unit.ByteSizeValue;

public class StoreRateLimiting {
    private final RateLimiter rateLimiter = new RateLimiter(0.0);
    private volatile RateLimiter actualRateLimiter;
    private volatile Type type;

    @Nullable
    public RateLimiter getRateLimiter() {
        return this.actualRateLimiter;
    }

    public void setMaxRate(ByteSizeValue rate) {
        if (rate.bytes() <= 0L) {
            this.actualRateLimiter = null;
        } else if (this.actualRateLimiter == null) {
            this.actualRateLimiter = this.rateLimiter;
            this.actualRateLimiter.setMaxRate(rate.mbFrac());
        } else {
            assert (this.rateLimiter == this.actualRateLimiter);
            this.rateLimiter.setMaxRate(rate.mbFrac());
        }
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type2) {
        this.type = type2;
    }

    public void setType(String type2) throws ElasticSearchIllegalArgumentException {
        this.type = Type.fromString(type2);
    }

    public static enum Type {
        NONE,
        MERGE,
        ALL;


        public static Type fromString(String type2) throws ElasticSearchIllegalArgumentException {
            if ("none".equalsIgnoreCase(type2)) {
                return NONE;
            }
            if ("merge".equalsIgnoreCase(type2)) {
                return MERGE;
            }
            if ("all".equalsIgnoreCase(type2)) {
                return ALL;
            }
            throw new ElasticSearchIllegalArgumentException("rate limiting type [" + type2 + "] not valid, can be one of [all|merge|none]");
        }
    }

    public static interface Listener {
        public void onPause(long var1);
    }

    public static interface Provider {
        public StoreRateLimiting rateLimiting();
    }
}

