/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;

public class VerifyingLockFactory
extends LockFactory {
    LockFactory lf;
    byte id;
    String host;
    int port;

    public VerifyingLockFactory(byte id2, LockFactory lf, String host, int port) throws IOException {
        this.id = id2;
        this.lf = lf;
        this.host = host;
        this.port = port;
    }

    public synchronized Lock makeLock(String lockName) {
        return new CheckedLock(this.lf.makeLock(lockName));
    }

    public synchronized void clearLock(String lockName) throws IOException {
        this.lf.clearLock(lockName);
    }

    private class CheckedLock
    extends Lock {
        private Lock lock;

        public CheckedLock(Lock lock2) {
            this.lock = lock2;
        }

        private void verify(byte message2) {
            try {
                Socket s2 = new Socket(VerifyingLockFactory.this.host, VerifyingLockFactory.this.port);
                OutputStream out = s2.getOutputStream();
                out.write(VerifyingLockFactory.this.id);
                out.write(message2);
                InputStream in = s2.getInputStream();
                int result2 = in.read();
                in.close();
                out.close();
                s2.close();
                if (result2 != 0) {
                    throw new RuntimeException("lock was double acquired");
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized boolean obtain(long lockWaitTimeout) throws LockObtainFailedException, IOException {
            boolean obtained = this.lock.obtain(lockWaitTimeout);
            if (obtained) {
                this.verify((byte)1);
            }
            return obtained;
        }

        public synchronized boolean obtain() throws LockObtainFailedException, IOException {
            return this.lock.obtain();
        }

        public synchronized boolean isLocked() throws IOException {
            return this.lock.isLocked();
        }

        public synchronized void release() throws IOException {
            if (this.isLocked()) {
                this.verify((byte)0);
                this.lock.release();
            }
        }
    }
}

