/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public interface ByteBufferAllocator {
    public int sizeInBytes(Type var1);

    public ByteBuffer allocate(Type var1) throws IOException;

    public void release(ByteBuffer var1);

    public void close();

    public static enum Type {
        SMALL,
        LARGE;

    }

    public static class Cleaner {
        public static final boolean CLEAN_SUPPORTED;
        private static final Method directBufferCleaner;
        private static final Method directBufferCleanerClean;

        public static void clean(ByteBuffer buffer) {
            if (CLEAN_SUPPORTED && buffer.isDirect()) {
                try {
                    Object cleaner = directBufferCleaner.invoke((Object)buffer, new Object[0]);
                    directBufferCleanerClean.invoke(cleaner, new Object[0]);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }

        static {
            boolean v;
            Method directBufferCleanerX = null;
            Method directBufferCleanerCleanX = null;
            try {
                directBufferCleanerX = Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
                directBufferCleanerX.setAccessible(true);
                directBufferCleanerCleanX = Class.forName("sun.misc.Cleaner").getMethod("clean", new Class[0]);
                directBufferCleanerCleanX.setAccessible(true);
                v = true;
            }
            catch (Exception e) {
                v = false;
            }
            CLEAN_SUPPORTED = v;
            directBufferCleaner = directBufferCleanerX;
            directBufferCleanerClean = directBufferCleanerCleanX;
        }
    }
}

