/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.bytebuffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.store.bytebuffer.ByteBufferAllocator;

public class PlainByteBufferAllocator
implements ByteBufferAllocator {
    protected final boolean direct;
    protected final int smallBufferSizeInBytes;
    protected final int largeBufferSizeInBytes;

    public PlainByteBufferAllocator(boolean direct, int smallBufferSizeInBytes, int largeBufferSizeInBytes) {
        this.direct = direct;
        this.smallBufferSizeInBytes = smallBufferSizeInBytes;
        this.largeBufferSizeInBytes = largeBufferSizeInBytes;
    }

    @Override
    public int sizeInBytes(ByteBufferAllocator.Type type2) {
        return type2 == ByteBufferAllocator.Type.SMALL ? this.smallBufferSizeInBytes : this.largeBufferSizeInBytes;
    }

    @Override
    public ByteBuffer allocate(ByteBufferAllocator.Type type2) throws IOException {
        int sizeToAllocate;
        int n = sizeToAllocate = type2 == ByteBufferAllocator.Type.SMALL ? this.smallBufferSizeInBytes : this.largeBufferSizeInBytes;
        if (this.direct) {
            return ByteBuffer.allocateDirect(sizeToAllocate);
        }
        return ByteBuffer.allocate(sizeToAllocate);
    }

    @Override
    public void release(ByteBuffer buffer) {
        ByteBufferAllocator.Cleaner.clean(buffer);
    }

    @Override
    public void close() {
    }
}

