/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

public final class ByteBlockPool {
    public static final int BYTE_BLOCK_SHIFT = 15;
    public static final int BYTE_BLOCK_SIZE = 32768;
    public static final int BYTE_BLOCK_MASK = Short.MAX_VALUE;
    public byte[][] buffers = new byte[10][];
    int bufferUpto = -1;
    public int byteUpto = 32768;
    public byte[] buffer;
    public int byteOffset = Short.MIN_VALUE;
    private final Allocator allocator;
    public static final int[] nextLevelArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
    public static final int[] levelSizeArray = new int[]{5, 14, 20, 30, 40, 40, 80, 80, 120, 200};
    public static final int FIRST_LEVEL_SIZE = levelSizeArray[0];

    public ByteBlockPool(Allocator allocator) {
        this.allocator = allocator;
    }

    public void dropBuffersAndReset() {
        if (this.bufferUpto != -1) {
            this.allocator.recycleByteBlocks(this.buffers, 0, 1 + this.bufferUpto);
            this.bufferUpto = -1;
            this.byteUpto = 32768;
            this.byteOffset = Short.MIN_VALUE;
            this.buffers = new byte[10][];
            this.buffer = null;
        }
    }

    public void reset() {
        if (this.bufferUpto != -1) {
            for (int i2 = 0; i2 < this.bufferUpto; ++i2) {
                Arrays.fill(this.buffers[i2], (byte)0);
            }
            Arrays.fill(this.buffers[this.bufferUpto], 0, this.byteUpto, (byte)0);
            if (this.bufferUpto > 0) {
                this.allocator.recycleByteBlocks(this.buffers, 1, 1 + this.bufferUpto);
            }
            this.bufferUpto = 0;
            this.byteUpto = 0;
            this.byteOffset = 0;
            this.buffer = this.buffers[0];
        }
    }

    public void nextBuffer() {
        if (1 + this.bufferUpto == this.buffers.length) {
            byte[][] newBuffers = new byte[ArrayUtil.oversize(this.buffers.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
        }
        byte[] byArray = this.allocator.getByteBlock();
        this.buffers[1 + this.bufferUpto] = byArray;
        this.buffer = byArray;
        ++this.bufferUpto;
        this.byteUpto = 0;
        this.byteOffset += 32768;
    }

    public int newSlice(int size2) {
        if (this.byteUpto > 32768 - size2) {
            this.nextBuffer();
        }
        int upto2 = this.byteUpto;
        this.byteUpto += size2;
        this.buffer[this.byteUpto - 1] = 16;
        return upto2;
    }

    public int allocSlice(byte[] slice, int upto2) {
        int level2 = slice[upto2] & 0xF;
        int newLevel = nextLevelArray[level2];
        int newSize = levelSizeArray[newLevel];
        if (this.byteUpto > 32768 - newSize) {
            this.nextBuffer();
        }
        int newUpto = this.byteUpto;
        int offset2 = newUpto + this.byteOffset;
        this.byteUpto += newSize;
        this.buffer[newUpto] = slice[upto2 - 3];
        this.buffer[newUpto + 1] = slice[upto2 - 2];
        this.buffer[newUpto + 2] = slice[upto2 - 1];
        slice[upto2 - 3] = (byte)(offset2 >>> 24);
        slice[upto2 - 2] = (byte)(offset2 >>> 16);
        slice[upto2 - 1] = (byte)(offset2 >>> 8);
        slice[upto2] = (byte)offset2;
        this.buffer[this.byteUpto - 1] = (byte)(0x10 | newLevel);
        return newUpto + 3;
    }

    public final BytesRef setBytesRef(BytesRef term, int textStart) {
        term.bytes = this.buffers[textStart >> 15];
        byte[] bytes2 = term.bytes;
        int pos2 = textStart & Short.MAX_VALUE;
        if ((bytes2[pos2] & 0x80) == 0) {
            term.length = bytes2[pos2];
            term.offset = pos2 + 1;
        } else {
            term.length = (bytes2[pos2] & 0x7F) + ((bytes2[pos2 + 1] & 0xFF) << 7);
            term.offset = pos2 + 2;
        }
        assert (term.length >= 0);
        return term;
    }

    public final void copy(BytesRef bytes2) {
        int length2 = bytes2.length;
        int offset2 = bytes2.offset;
        int overflow = length2 + this.byteUpto - 32768;
        while (true) {
            if (overflow <= 0) {
                System.arraycopy(bytes2.bytes, offset2, this.buffer, this.byteUpto, length2);
                this.byteUpto += length2;
                break;
            }
            int bytesToCopy = length2 - overflow;
            System.arraycopy(bytes2.bytes, offset2, this.buffer, this.byteUpto, bytesToCopy);
            offset2 += bytesToCopy;
            length2 -= bytesToCopy;
            this.nextBuffer();
            overflow -= 32768;
        }
    }

    public final BytesRef copyFrom(BytesRef bytes2) {
        int length2 = bytes2.length;
        int offset2 = bytes2.offset;
        bytes2.offset = 0;
        bytes2.grow(length2);
        int bufferIndex = offset2 >> 15;
        byte[] buffer = this.buffers[bufferIndex];
        int pos2 = offset2 & Short.MAX_VALUE;
        int overflow = pos2 + length2 - 32768;
        while (true) {
            if (overflow <= 0) break;
            int bytesToCopy = length2 - overflow;
            System.arraycopy(buffer, pos2, bytes2.bytes, bytes2.offset, bytesToCopy);
            pos2 = 0;
            bytes2.length -= bytesToCopy;
            bytes2.offset += bytesToCopy;
            buffer = this.buffers[++bufferIndex];
            overflow -= 32768;
        }
        System.arraycopy(buffer, pos2, bytes2.bytes, bytes2.offset, bytes2.length);
        bytes2.length = length2;
        bytes2.offset = 0;
        return bytes2;
    }

    public final void writePool(DataOutput out) throws IOException {
        int block = 0;
        for (int bytesOffset = this.byteOffset; bytesOffset > 0; bytesOffset -= 32768) {
            out.writeBytes(this.buffers[block++], 32768);
        }
        out.writeBytes(this.buffers[block], this.byteUpto);
    }

    public static class DirectTrackingAllocator
    extends Allocator {
        private final AtomicLong bytesUsed;

        public DirectTrackingAllocator(AtomicLong bytesUsed) {
            this(32768, bytesUsed);
        }

        public DirectTrackingAllocator(int blockSize, AtomicLong bytesUsed) {
            super(blockSize);
            this.bytesUsed = bytesUsed;
        }

        public byte[] getByteBlock() {
            this.bytesUsed.addAndGet(this.blockSize);
            return new byte[this.blockSize];
        }

        public void recycleByteBlocks(byte[][] blocks2, int start2, int end2) {
            this.bytesUsed.addAndGet(-((end2 - start2) * this.blockSize));
            for (int i2 = start2; i2 < end2; ++i2) {
                blocks2[i2] = null;
            }
        }
    }

    public static final class DirectAllocator
    extends Allocator {
        public DirectAllocator() {
            this(32768);
        }

        public DirectAllocator(int blockSize) {
            super(blockSize);
        }

        public void recycleByteBlocks(byte[][] blocks2, int start2, int end2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Allocator {
        protected final int blockSize;

        public Allocator(int blockSize) {
            this.blockSize = blockSize;
        }

        public abstract void recycleByteBlocks(byte[][] var1, int var2, int var3);

        public void recycleByteBlocks(List<byte[]> blocks2) {
            byte[][] b = (byte[][])blocks2.toArray((T[])new byte[blocks2.size()][]);
            this.recycleByteBlocks(b, 0, b.length);
        }

        public byte[] getByteBlock() {
            return new byte[this.blockSize];
        }
    }
}

