/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.UnicodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BytesRef
implements Comparable<BytesRef>,
Cloneable {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public byte[] bytes;
    public int offset;
    public int length;
    private static final Comparator<BytesRef> utf8SortedAsUnicodeSortOrder = new UTF8SortedAsUnicodeComparator();
    private static final Comparator<BytesRef> utf8SortedAsUTF16SortOrder = new UTF8SortedAsUTF16Comparator();

    public BytesRef() {
        this(EMPTY_BYTES);
    }

    public BytesRef(byte[] bytes2, int offset2, int length2) {
        assert (bytes2 != null);
        assert (offset2 >= 0);
        assert (length2 >= 0);
        assert (bytes2.length >= offset2 + length2);
        this.bytes = bytes2;
        this.offset = offset2;
        this.length = length2;
    }

    public BytesRef(byte[] bytes2) {
        this(bytes2, 0, bytes2.length);
    }

    public BytesRef(int capacity) {
        this.bytes = new byte[capacity];
    }

    public BytesRef(CharSequence text) {
        this();
        this.copyChars(text);
    }

    public void copyChars(CharSequence text) {
        assert (this.offset == 0);
        UnicodeUtil.UTF16toUTF8(text, 0, text.length(), this);
    }

    public void copyChars(char[] text, int offset2, int length2) {
        UnicodeUtil.UTF16toUTF8(text, offset2, length2, this);
    }

    public boolean bytesEquals(BytesRef other) {
        assert (other != null);
        if (this.length == other.length) {
            int otherUpto = other.offset;
            byte[] otherBytes = other.bytes;
            int end2 = this.offset + this.length;
            int upto2 = this.offset;
            while (upto2 < end2) {
                if (this.bytes[upto2] != otherBytes[otherUpto]) {
                    return false;
                }
                ++upto2;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    public BytesRef clone() {
        return new BytesRef(this.bytes, this.offset, this.length);
    }

    private boolean sliceEquals(BytesRef other, int pos2) {
        if (pos2 < 0 || this.length - pos2 < other.length) {
            return false;
        }
        int i2 = this.offset + pos2;
        int j = other.offset;
        int k = other.offset + other.length;
        while (j < k) {
            if (this.bytes[i2++] == other.bytes[j++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(BytesRef other) {
        return this.sliceEquals(other, 0);
    }

    public boolean endsWith(BytesRef other) {
        return this.sliceEquals(other, this.length - other.length);
    }

    public int hashCode() {
        int hash2 = 0;
        int end2 = this.offset + this.length;
        for (int i2 = this.offset; i2 < end2; ++i2) {
            hash2 = 31 * hash2 + this.bytes[i2];
        }
        return hash2;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof BytesRef) {
            return this.bytesEquals((BytesRef)other);
        }
        return false;
    }

    public String utf8ToString() {
        try {
            return new String(this.bytes, this.offset, this.length, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int end2 = this.offset + this.length;
        for (int i2 = this.offset; i2 < end2; ++i2) {
            if (i2 > this.offset) {
                sb.append(' ');
            }
            sb.append(Integer.toHexString(this.bytes[i2] & 0xFF));
        }
        sb.append(']');
        return sb.toString();
    }

    public void copyBytes(BytesRef other) {
        if (this.bytes.length - this.offset < other.length) {
            this.bytes = new byte[other.length];
            this.offset = 0;
        }
        System.arraycopy(other.bytes, other.offset, this.bytes, this.offset, other.length);
        this.length = other.length;
    }

    public void append(BytesRef other) {
        int newLen = this.length + other.length;
        if (this.bytes.length - this.offset < newLen) {
            byte[] newBytes = new byte[newLen];
            System.arraycopy(this.bytes, this.offset, newBytes, 0, this.length);
            this.offset = 0;
            this.bytes = newBytes;
        }
        System.arraycopy(other.bytes, other.offset, this.bytes, this.length + this.offset, other.length);
        this.length = newLen;
    }

    public void grow(int newLength) {
        assert (this.offset == 0);
        this.bytes = ArrayUtil.grow(this.bytes, newLength);
    }

    @Override
    public int compareTo(BytesRef other) {
        return utf8SortedAsUnicodeSortOrder.compare(this, other);
    }

    public static Comparator<BytesRef> getUTF8SortedAsUnicodeComparator() {
        return utf8SortedAsUnicodeSortOrder;
    }

    public static Comparator<BytesRef> getUTF8SortedAsUTF16Comparator() {
        return utf8SortedAsUTF16SortOrder;
    }

    public static BytesRef deepCopyOf(BytesRef other) {
        BytesRef copy = new BytesRef();
        copy.copyBytes(other);
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UTF8SortedAsUTF16Comparator
    implements Comparator<BytesRef> {
        private UTF8SortedAsUTF16Comparator() {
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            byte[] aBytes = a.bytes;
            int aUpto = a.offset;
            byte[] bBytes = b.bytes;
            int bUpto = b.offset;
            int aStop = a.length < b.length ? aUpto + a.length : aUpto + b.length;
            while (aUpto < aStop) {
                int bByte;
                int aByte;
                if ((aByte = aBytes[aUpto++] & 0xFF) == (bByte = bBytes[bUpto++] & 0xFF)) continue;
                if (aByte >= 238 && bByte >= 238) {
                    if ((aByte & 0xFE) == 238) {
                        aByte += 14;
                    }
                    if ((bByte & 0xFE) == 238) {
                        bByte += 14;
                    }
                }
                return aByte - bByte;
            }
            return a.length - b.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UTF8SortedAsUnicodeComparator
    implements Comparator<BytesRef> {
        private UTF8SortedAsUnicodeComparator() {
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            byte[] aBytes = a.bytes;
            int aUpto = a.offset;
            byte[] bBytes = b.bytes;
            int bUpto = b.offset;
            int aStop = aUpto + Math.min(a.length, b.length);
            while (aUpto < aStop) {
                int bByte;
                int aByte;
                int diff;
                if ((diff = (aByte = aBytes[aUpto++] & 0xFF) - (bByte = bBytes[bUpto++] & 0xFF)) == 0) continue;
                return diff;
            }
            return a.length - b.length;
        }
    }
}

