/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.util.SorterTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtil {
    private CollectionUtil() {
    }

    private static <T> SorterTemplate getSorter(final List<T> list2, final Comparator<? super T> comp) {
        if (!(list2 instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        return new SorterTemplate(){
            private T pivot;

            protected void swap(int i2, int j) {
                Collections.swap(list2, i2, j);
            }

            protected int compare(int i2, int j) {
                return comp.compare(list2.get(i2), list2.get(j));
            }

            protected void setPivot(int i2) {
                this.pivot = list2.get(i2);
            }

            protected int comparePivot(int j) {
                return comp.compare(this.pivot, list2.get(j));
            }
        };
    }

    private static <T extends Comparable<? super T>> SorterTemplate getSorter(final List<T> list2) {
        if (!(list2 instanceof RandomAccess)) {
            throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
        }
        return new SorterTemplate(){
            private T pivot;

            protected void swap(int i2, int j) {
                Collections.swap(list2, i2, j);
            }

            protected int compare(int i2, int j) {
                return ((Comparable)list2.get(i2)).compareTo(list2.get(j));
            }

            protected void setPivot(int i2) {
                this.pivot = (Comparable)list2.get(i2);
            }

            protected int comparePivot(int j) {
                return this.pivot.compareTo(list2.get(j));
            }
        };
    }

    public static <T> void quickSort(List<T> list2, Comparator<? super T> comp) {
        int size2 = list2.size();
        if (size2 <= 1) {
            return;
        }
        CollectionUtil.getSorter(list2, comp).quickSort(0, size2 - 1);
    }

    public static <T extends Comparable<? super T>> void quickSort(List<T> list2) {
        int size2 = list2.size();
        if (size2 <= 1) {
            return;
        }
        CollectionUtil.getSorter(list2).quickSort(0, size2 - 1);
    }

    public static <T> void mergeSort(List<T> list2, Comparator<? super T> comp) {
        int size2 = list2.size();
        if (size2 <= 1) {
            return;
        }
        CollectionUtil.getSorter(list2, comp).mergeSort(0, size2 - 1);
    }

    public static <T extends Comparable<? super T>> void mergeSort(List<T> list2) {
        int size2 = list2.size();
        if (size2 <= 1) {
            return;
        }
        CollectionUtil.getSorter(list2).mergeSort(0, size2 - 1);
    }

    public static <T> void insertionSort(List<T> list2, Comparator<? super T> comp) {
        int size2 = list2.size();
        if (size2 <= 1) {
            return;
        }
        CollectionUtil.getSorter(list2, comp).insertionSort(0, size2 - 1);
    }

    public static <T extends Comparable<? super T>> void insertionSort(List<T> list2) {
        int size2 = list2.size();
        if (size2 <= 1) {
            return;
        }
        CollectionUtil.getSorter(list2).insertionSort(0, size2 - 1);
    }
}

