/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.RamUsageEstimator;

public final class RecyclingByteBlockAllocator
extends ByteBlockPool.Allocator {
    private byte[][] freeByteBlocks;
    private final int maxBufferedBlocks;
    private int freeBlocks = 0;
    private final AtomicLong bytesUsed;
    public static final int DEFAULT_BUFFERED_BLOCKS = 64;

    public RecyclingByteBlockAllocator(int blockSize, int maxBufferedBlocks, AtomicLong bytesUsed) {
        super(blockSize);
        this.freeByteBlocks = new byte[Math.min(10, maxBufferedBlocks)][];
        this.maxBufferedBlocks = maxBufferedBlocks;
        this.bytesUsed = bytesUsed;
    }

    public RecyclingByteBlockAllocator(int blockSize, int maxBufferedBlocks) {
        this(blockSize, maxBufferedBlocks, new AtomicLong());
    }

    public RecyclingByteBlockAllocator() {
        this(32768, 64, new AtomicLong());
    }

    public synchronized byte[] getByteBlock() {
        if (this.freeBlocks == 0) {
            this.bytesUsed.addAndGet(this.blockSize);
            return new byte[this.blockSize];
        }
        byte[] b = this.freeByteBlocks[--this.freeBlocks];
        this.freeByteBlocks[this.freeBlocks] = null;
        return b;
    }

    public synchronized void recycleByteBlocks(byte[][] blocks2, int start2, int end2) {
        int i2;
        int numBlocks = Math.min(this.maxBufferedBlocks - this.freeBlocks, end2 - start2);
        int size2 = this.freeBlocks + numBlocks;
        if (size2 >= this.freeByteBlocks.length) {
            byte[][] newBlocks = new byte[ArrayUtil.oversize(size2, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(this.freeByteBlocks, 0, newBlocks, 0, this.freeBlocks);
            this.freeByteBlocks = newBlocks;
        }
        int stop2 = start2 + numBlocks;
        for (i2 = start2; i2 < stop2; ++i2) {
            this.freeByteBlocks[this.freeBlocks++] = blocks2[i2];
            blocks2[i2] = null;
        }
        for (i2 = stop2; i2 < end2; ++i2) {
            blocks2[i2] = null;
        }
        this.bytesUsed.addAndGet(-(end2 - stop2) * this.blockSize);
        assert (this.bytesUsed.get() >= 0L);
    }

    public synchronized int numBufferedBlocks() {
        return this.freeBlocks;
    }

    public long bytesUsed() {
        return this.bytesUsed.get();
    }

    public int maxBufferedBlocks() {
        return this.maxBufferedBlocks;
    }

    public synchronized int freeBlocks(int num) {
        int count2;
        int stop2;
        assert (num >= 0);
        if (num > this.freeBlocks) {
            stop2 = 0;
            count2 = this.freeBlocks;
        } else {
            stop2 = this.freeBlocks - num;
            count2 = num;
        }
        while (this.freeBlocks > stop2) {
            this.freeByteBlocks[--this.freeBlocks] = null;
        }
        this.bytesUsed.addAndGet(-count2 * this.blockSize);
        assert (this.bytesUsed.get() >= 0L);
        return count2;
    }
}

