/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.util.ArrayUtil;

public final class RollingCharBuffer {
    private Reader reader;
    private char[] buffer = new char[32];
    private int nextWrite;
    private int nextPos;
    private int count;
    private boolean end;

    public void reset(Reader reader) {
        this.reader = reader;
        this.nextPos = 0;
        this.nextWrite = 0;
        this.count = 0;
        this.end = false;
    }

    public int get(int pos2) throws IOException {
        if (pos2 == this.nextPos) {
            if (this.end) {
                return -1;
            }
            int ch = this.reader.read();
            if (ch == -1) {
                this.end = true;
                return -1;
            }
            if (this.count == this.buffer.length) {
                char[] newBuffer = new char[ArrayUtil.oversize(1 + this.count, 2)];
                System.arraycopy(this.buffer, this.nextWrite, newBuffer, 0, this.buffer.length - this.nextWrite);
                System.arraycopy(this.buffer, 0, newBuffer, this.buffer.length - this.nextWrite, this.nextWrite);
                this.nextWrite = this.buffer.length;
                this.buffer = newBuffer;
            }
            if (this.nextWrite == this.buffer.length) {
                this.nextWrite = 0;
            }
            this.buffer[this.nextWrite++] = (char)ch;
            ++this.count;
            ++this.nextPos;
            return ch;
        }
        assert (pos2 < this.nextPos);
        assert (this.nextPos - pos2 <= this.count) : "nextPos=" + this.nextPos + " pos=" + pos2 + " count=" + this.count;
        int index2 = this.getIndex(pos2);
        return this.buffer[index2];
    }

    private boolean inBounds(int pos2) {
        return pos2 >= 0 && pos2 < this.nextPos && pos2 >= this.nextPos - this.count;
    }

    private int getIndex(int pos2) {
        int index2 = this.nextWrite - (this.nextPos - pos2);
        if (index2 < 0) assert ((index2 += this.buffer.length) >= 0);
        return index2;
    }

    public char[] get(int posStart, int length2) {
        assert (length2 > 0);
        assert (this.inBounds(posStart)) : "posStart=" + posStart + " length=" + length2;
        int startIndex = this.getIndex(posStart);
        int endIndex = this.getIndex(posStart + length2);
        char[] result2 = new char[length2];
        if (endIndex >= startIndex && length2 < this.buffer.length) {
            System.arraycopy(this.buffer, startIndex, result2, 0, endIndex - startIndex);
        } else {
            int part1 = this.buffer.length - startIndex;
            System.arraycopy(this.buffer, startIndex, result2, 0, part1);
            System.arraycopy(this.buffer, 0, result2, this.buffer.length - startIndex, length2 - part1);
        }
        return result2;
    }

    public void freeBefore(int pos2) {
        assert (pos2 >= 0);
        assert (pos2 <= this.nextPos);
        int newCount = this.nextPos - pos2;
        assert (newCount <= this.count) : "newCount=" + newCount + " count=" + this.count;
        assert (newCount <= this.buffer.length) : "newCount=" + newCount + " buf.length=" + this.buffer.length;
        this.count = newCount;
    }
}

