/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.util;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERApplicationSpecific;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERExternal;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.encoders.Hex;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static void _dumpAsString(String string2, boolean bl, ASN1Primitive aSN1Primitive, StringBuffer stringBuffer) {
        String string3 = System.getProperty("line.separator");
        if (aSN1Primitive instanceof ASN1Sequence) {
            Enumeration enumeration = ((ASN1Sequence)aSN1Primitive).getObjects();
            String string4 = string2 + TAB;
            stringBuffer.append(string2);
            if (aSN1Primitive instanceof BERSequence) {
                stringBuffer.append("BER Sequence");
            } else if (aSN1Primitive instanceof DERSequence) {
                stringBuffer.append("DER Sequence");
            } else {
                stringBuffer.append("Sequence");
            }
            stringBuffer.append(string3);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null || e.equals(new DERNull())) {
                    stringBuffer.append(string4);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string3);
                    continue;
                }
                if (e instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(string4, bl, (ASN1Primitive)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string4, bl, ((ASN1Encodable)e).toASN1Primitive(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof DERTaggedObject) {
            String string5 = string2 + TAB;
            stringBuffer.append(string2);
            if (aSN1Primitive instanceof BERTaggedObject) {
                stringBuffer.append("BER Tagged [");
            } else {
                stringBuffer.append("Tagged [");
            }
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Primitive;
            stringBuffer.append(Integer.toString(dERTaggedObject.getTagNo()));
            stringBuffer.append(']');
            if (!dERTaggedObject.isExplicit()) {
                stringBuffer.append(" IMPLICIT ");
            }
            stringBuffer.append(string3);
            if (dERTaggedObject.isEmpty()) {
                stringBuffer.append(string5);
                stringBuffer.append("EMPTY");
                stringBuffer.append(string3);
            } else {
                ASN1Dump._dumpAsString(string5, bl, dERTaggedObject.getObject(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof BERSet) {
            Enumeration enumeration = ((ASN1Set)aSN1Primitive).getObjects();
            String string6 = string2 + TAB;
            stringBuffer.append(string2);
            stringBuffer.append("BER Set");
            stringBuffer.append(string3);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string6);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string3);
                    continue;
                }
                if (e instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(string6, bl, (ASN1Primitive)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string6, bl, ((ASN1Encodable)e).toASN1Primitive(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof DERSet) {
            Enumeration enumeration = ((ASN1Set)aSN1Primitive).getObjects();
            String string7 = string2 + TAB;
            stringBuffer.append(string2);
            stringBuffer.append("DER Set");
            stringBuffer.append(string3);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string7);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string3);
                    continue;
                }
                if (e instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(string7, bl, (ASN1Primitive)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string7, bl, ((ASN1Encodable)e).toASN1Primitive(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
            stringBuffer.append(string2 + "ObjectIdentifier(" + ((ASN1ObjectIdentifier)aSN1Primitive).getId() + ")" + string3);
        } else if (aSN1Primitive instanceof DERBoolean) {
            stringBuffer.append(string2 + "Boolean(" + ((DERBoolean)aSN1Primitive).isTrue() + ")" + string3);
        } else if (aSN1Primitive instanceof ASN1Integer) {
            stringBuffer.append(string2 + "Integer(" + ((ASN1Integer)aSN1Primitive).getValue() + ")" + string3);
        } else if (aSN1Primitive instanceof BERConstructedOctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Primitive;
            stringBuffer.append(string2 + "BER Constructed Octet String" + "[" + aSN1OctetString.getOctets().length + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, aSN1OctetString.getOctets()));
            } else {
                stringBuffer.append(string3);
            }
        } else if (aSN1Primitive instanceof DEROctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Primitive;
            stringBuffer.append(string2 + "DER Octet String" + "[" + aSN1OctetString.getOctets().length + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, aSN1OctetString.getOctets()));
            } else {
                stringBuffer.append(string3);
            }
        } else if (aSN1Primitive instanceof DERBitString) {
            DERBitString dERBitString = (DERBitString)aSN1Primitive;
            stringBuffer.append(string2 + "DER Bit String" + "[" + dERBitString.getBytes().length + ", " + dERBitString.getPadBits() + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, dERBitString.getBytes()));
            } else {
                stringBuffer.append(string3);
            }
        } else if (aSN1Primitive instanceof DERIA5String) {
            stringBuffer.append(string2 + "IA5String(" + ((DERIA5String)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERUTF8String) {
            stringBuffer.append(string2 + "UTF8String(" + ((DERUTF8String)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERPrintableString) {
            stringBuffer.append(string2 + "PrintableString(" + ((DERPrintableString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERVisibleString) {
            stringBuffer.append(string2 + "VisibleString(" + ((DERVisibleString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERBMPString) {
            stringBuffer.append(string2 + "BMPString(" + ((DERBMPString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERT61String) {
            stringBuffer.append(string2 + "T61String(" + ((DERT61String)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERUTCTime) {
            stringBuffer.append(string2 + "UTCTime(" + ((DERUTCTime)aSN1Primitive).getTime() + ") " + string3);
        } else if (aSN1Primitive instanceof DERGeneralizedTime) {
            stringBuffer.append(string2 + "GeneralizedTime(" + ((DERGeneralizedTime)aSN1Primitive).getTime() + ") " + string3);
        } else if (aSN1Primitive instanceof BERApplicationSpecific) {
            stringBuffer.append(ASN1Dump.outputApplicationSpecific("BER", string2, bl, aSN1Primitive, string3));
        } else if (aSN1Primitive instanceof DERApplicationSpecific) {
            stringBuffer.append(ASN1Dump.outputApplicationSpecific("DER", string2, bl, aSN1Primitive, string3));
        } else if (aSN1Primitive instanceof DEREnumerated) {
            DEREnumerated dEREnumerated = (DEREnumerated)aSN1Primitive;
            stringBuffer.append(string2 + "DER Enumerated(" + dEREnumerated.getValue() + ")" + string3);
        } else if (aSN1Primitive instanceof DERExternal) {
            DERExternal dERExternal = (DERExternal)aSN1Primitive;
            stringBuffer.append(string2 + "External " + string3);
            String string8 = string2 + TAB;
            if (dERExternal.getDirectReference() != null) {
                stringBuffer.append(string8 + "Direct Reference: " + dERExternal.getDirectReference().getId() + string3);
            }
            if (dERExternal.getIndirectReference() != null) {
                stringBuffer.append(string8 + "Indirect Reference: " + dERExternal.getIndirectReference().toString() + string3);
            }
            if (dERExternal.getDataValueDescriptor() != null) {
                ASN1Dump._dumpAsString(string8, bl, dERExternal.getDataValueDescriptor(), stringBuffer);
            }
            stringBuffer.append(string8 + "Encoding: " + dERExternal.getEncoding() + string3);
            ASN1Dump._dumpAsString(string8, bl, dERExternal.getExternalContent(), stringBuffer);
        } else {
            stringBuffer.append(string2 + aSN1Primitive.toString() + string3);
        }
    }

    private static String outputApplicationSpecific(String string2, String string3, boolean bl, ASN1Primitive aSN1Primitive, String string4) {
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)aSN1Primitive;
        StringBuffer stringBuffer = new StringBuffer();
        if (dERApplicationSpecific.isConstructed()) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(dERApplicationSpecific.getObject(16));
                stringBuffer.append(string3 + string2 + " ApplicationSpecific[" + dERApplicationSpecific.getApplicationTag() + "]" + string4);
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    ASN1Dump._dumpAsString(string3 + TAB, bl, (ASN1Primitive)enumeration.nextElement(), stringBuffer);
                }
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException);
            }
            return stringBuffer.toString();
        }
        return string3 + string2 + " ApplicationSpecific[" + dERApplicationSpecific.getApplicationTag() + "] (" + new String(Hex.encode(dERApplicationSpecific.getContents())) + ")" + string4;
    }

    public static String dumpAsString(Object object) {
        return ASN1Dump.dumpAsString(object, false);
    }

    public static String dumpAsString(Object object, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof ASN1Primitive) {
            ASN1Dump._dumpAsString("", bl, (ASN1Primitive)object, stringBuffer);
        } else if (object instanceof ASN1Encodable) {
            ASN1Dump._dumpAsString("", bl, ((ASN1Encodable)object).toASN1Primitive(), stringBuffer);
        } else {
            return "unknown object type " + object.toString();
        }
        return stringBuffer.toString();
    }

    private static String dumpBinaryDataAsString(String string2, byte[] byArray) {
        String string3 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string2 + TAB;
        stringBuffer.append(string3);
        for (int j = 0; j < byArray.length; j += 32) {
            if (byArray.length - j > 32) {
                stringBuffer.append(string2);
                stringBuffer.append(new String(Hex.encode(byArray, j, 32)));
                stringBuffer.append(TAB);
                stringBuffer.append(ASN1Dump.calculateAscString(byArray, j, 32));
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(new String(Hex.encode(byArray, j, byArray.length - j)));
            for (int k = byArray.length - j; k != 32; ++k) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(TAB);
            stringBuffer.append(ASN1Dump.calculateAscString(byArray, j, byArray.length - j));
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String calculateAscString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = n; j != n + n2; ++j) {
            if (byArray[j] < 32 || byArray[j] > 126) continue;
            stringBuffer.append((char)byArray[j]);
        }
        return stringBuffer.toString();
    }
}

