/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBSONCallback
implements BSONCallback {
    private Object _root;
    private final LinkedList<BSONObject> _stack = new LinkedList();
    private final LinkedList<String> _nameStack = new LinkedList();

    public BasicBSONCallback() {
        this.reset();
    }

    public BSONObject create() {
        return new BasicBSONObject();
    }

    protected BSONObject createList() {
        return new BasicBSONList();
    }

    @Override
    public BSONCallback createBSONCallback() {
        return new BasicBSONCallback();
    }

    public BSONObject create(boolean array, List<String> path2) {
        if (array) {
            return this.createList();
        }
        return this.create();
    }

    @Override
    public void objectStart() {
        if (this._stack.size() > 0) {
            throw new IllegalStateException("something is wrong");
        }
        this.objectStart(false);
    }

    @Override
    public void objectStart(boolean array) {
        this._root = this.create(array, null);
        this._stack.add((BSONObject)this._root);
    }

    @Override
    public void objectStart(String name2) {
        this.objectStart(false, name2);
    }

    public void objectStart(boolean array, String name2) {
        this._nameStack.addLast(name2);
        BSONObject o = this.create(array, this._nameStack);
        this._stack.getLast().put(name2, o);
        this._stack.addLast(o);
    }

    @Override
    public Object objectDone() {
        BSONObject o = this._stack.removeLast();
        if (this._nameStack.size() > 0) {
            this._nameStack.removeLast();
        } else if (this._stack.size() > 0) {
            throw new IllegalStateException("something is wrong");
        }
        return !BSON.hasDecodeHooks() ? o : (BSONObject)BSON.applyDecodingHooks(o);
    }

    @Override
    public void arrayStart() {
        this.objectStart(true);
    }

    @Override
    public void arrayStart(String name2) {
        this.objectStart(true, name2);
    }

    @Override
    public Object arrayDone() {
        return this.objectDone();
    }

    @Override
    public void gotNull(String name2) {
        this.cur().put(name2, null);
    }

    @Override
    public void gotUndefined(String name2) {
    }

    @Override
    public void gotMinKey(String name2) {
        this.cur().put(name2, new MinKey());
    }

    @Override
    public void gotMaxKey(String name2) {
        this.cur().put(name2, new MaxKey());
    }

    @Override
    public void gotBoolean(String name2, boolean v) {
        this._put(name2, v);
    }

    @Override
    public void gotDouble(String name2, double v) {
        this._put(name2, v);
    }

    @Override
    public void gotInt(String name2, int v) {
        this._put(name2, v);
    }

    @Override
    public void gotLong(String name2, long v) {
        this._put(name2, v);
    }

    @Override
    public void gotDate(String name2, long millis) {
        this._put(name2, new Date(millis));
    }

    @Override
    public void gotRegex(String name2, String pattern, String flags) {
        this._put(name2, Pattern.compile(pattern, BSON.regexFlags(flags)));
    }

    @Override
    public void gotString(String name2, String v) {
        this._put(name2, v);
    }

    @Override
    public void gotSymbol(String name2, String v) {
        this._put(name2, v);
    }

    @Override
    public void gotTimestamp(String name2, int time, int inc) {
        this._put(name2, new BSONTimestamp(time, inc));
    }

    @Override
    public void gotObjectId(String name2, ObjectId id2) {
        this._put(name2, id2);
    }

    @Override
    public void gotDBRef(String name2, String ns, ObjectId id2) {
        this._put(name2, new BasicBSONObject("$ns", ns).append("$id", id2));
    }

    @Override
    @Deprecated
    public void gotBinaryArray(String name2, byte[] data2) {
        this.gotBinary(name2, (byte)0, data2);
    }

    @Override
    public void gotBinary(String name2, byte type2, byte[] data2) {
        if (type2 == 0 || type2 == 2) {
            this._put(name2, data2);
        } else {
            this._put(name2, new Binary(type2, data2));
        }
    }

    @Override
    public void gotUUID(String name2, long part1, long part2) {
        this._put(name2, new UUID(part1, part2));
    }

    @Override
    public void gotCode(String name2, String code) {
        this._put(name2, new Code(code));
    }

    @Override
    public void gotCodeWScope(String name2, String code, Object scope) {
        this._put(name2, new CodeWScope(code, (BSONObject)scope));
    }

    protected void _put(String name2, Object o) {
        this.cur().put(name2, !BSON.hasDecodeHooks() ? o : BSON.applyDecodingHooks(o));
    }

    protected BSONObject cur() {
        return this._stack.getLast();
    }

    protected String curName() {
        return !this._nameStack.isEmpty() ? this._nameStack.getLast() : null;
    }

    @Override
    public Object get() {
        return this._root;
    }

    protected void setRoot(Object o) {
        this._root = o;
    }

    protected boolean isStackEmpty() {
        return this._stack.size() < 1;
    }

    @Override
    public void reset() {
        this._root = null;
        this._stack.clear();
        this._nameStack.clear();
    }
}

