/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.mongodb.DBRefBase;
import com.mongodb.util.MyAsserts;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

public class BasicBSONEncoder
implements BSONEncoder {
    static final boolean DEBUG = false;
    protected OutputBuffer _buf;

    public byte[] encode(BSONObject o) {
        BasicOutputBuffer buf = new BasicOutputBuffer();
        this.set(buf);
        this.putObject(o);
        this.done();
        return buf.toByteArray();
    }

    public void set(OutputBuffer out) {
        if (this._buf != null) {
            throw new IllegalStateException("in the middle of something");
        }
        this._buf = out;
    }

    public void done() {
        this._buf = null;
    }

    protected boolean handleSpecialObjects(String name2, BSONObject o) {
        return false;
    }

    protected boolean putSpecial(String name2, Object o) {
        return false;
    }

    public int putObject(BSONObject o) {
        return this.putObject(null, o);
    }

    protected int putObject(String name2, BSONObject o) {
        boolean rewriteID;
        if (o == null) {
            throw new NullPointerException("can't save a null object");
        }
        int start2 = this._buf.getPosition();
        byte myType = 3;
        if (o instanceof List) {
            myType = 4;
        }
        if (this.handleSpecialObjects(name2, o)) {
            return this._buf.getPosition() - start2;
        }
        if (name2 != null) {
            this._put(myType, name2);
        }
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        List transientFields = null;
        boolean bl = rewriteID = myType == 3 && name2 == null;
        if (myType == 3) {
            Object temp;
            if (rewriteID && o.containsField("_id")) {
                this._putObjectField("_id", o.get("_id"));
            }
            if ((temp = o.get("_transientFields")) instanceof List) {
                transientFields = (List)temp;
            }
        }
        if (o instanceof Map) {
            for (Map.Entry entry : ((Map)((Object)o)).entrySet()) {
                if (rewriteID && ((String)entry.getKey()).equals("_id") || transientFields != null && transientFields.contains(entry.getKey())) continue;
                this._putObjectField((String)entry.getKey(), entry.getValue());
            }
        } else {
            for (String string2 : o.keySet()) {
                if (rewriteID && string2.equals("_id") || transientFields != null && transientFields.contains(string2)) continue;
                Object val = o.get(string2);
                this._putObjectField(string2, val);
            }
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
        return this._buf.getPosition() - start2;
    }

    protected void _putObjectField(String name2, Object val) {
        if (name2.equals("_transientFields")) {
            return;
        }
        if (name2.equals("$where") && val instanceof String) {
            this._put((byte)13, name2);
            this._putValueString(val.toString());
            return;
        }
        if ((val = BSON.applyEncodingHooks(val)) == null) {
            this.putNull(name2);
        } else if (val instanceof Date) {
            this.putDate(name2, (Date)val);
        } else if (val instanceof Number) {
            this.putNumber(name2, (Number)val);
        } else if (val instanceof Character) {
            this.putString(name2, val.toString());
        } else if (val instanceof String) {
            this.putString(name2, val.toString());
        } else if (val instanceof ObjectId) {
            this.putObjectId(name2, (ObjectId)val);
        } else if (val instanceof BSONObject) {
            this.putObject(name2, (BSONObject)val);
        } else if (val instanceof Boolean) {
            this.putBoolean(name2, (Boolean)val);
        } else if (val instanceof Pattern) {
            this.putPattern(name2, (Pattern)val);
        } else if (val instanceof Map) {
            this.putMap(name2, (Map)val);
        } else if (val instanceof Iterable) {
            this.putIterable(name2, (Iterable)val);
        } else if (val instanceof byte[]) {
            this.putBinary(name2, (byte[])val);
        } else if (val instanceof Binary) {
            this.putBinary(name2, (Binary)val);
        } else if (val instanceof UUID) {
            this.putUUID(name2, (UUID)val);
        } else if (val.getClass().isArray()) {
            this.putArray(name2, val);
        } else if (val instanceof Symbol) {
            this.putSymbol(name2, (Symbol)val);
        } else if (val instanceof BSONTimestamp) {
            this.putTimestamp(name2, (BSONTimestamp)val);
        } else if (val instanceof CodeWScope) {
            this.putCodeWScope(name2, (CodeWScope)val);
        } else if (val instanceof Code) {
            this.putCode(name2, (Code)val);
        } else if (val instanceof DBRefBase) {
            BasicBSONObject temp = new BasicBSONObject();
            temp.put("$ref", (Object)((DBRefBase)val).getRef());
            temp.put("$id", ((DBRefBase)val).getId());
            this.putObject(name2, temp);
        } else if (val instanceof MinKey) {
            this.putMinKey(name2);
        } else if (val instanceof MaxKey) {
            this.putMaxKey(name2);
        } else if (!this.putSpecial(name2, val)) {
            throw new IllegalArgumentException("can't serialize " + val.getClass());
        }
    }

    private void putArray(String name2, Object array) {
        this._put((byte)4, name2);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        int size2 = Array.getLength(array);
        for (int i2 = 0; i2 < size2; ++i2) {
            this._putObjectField(String.valueOf(i2), Array.get(array, i2));
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    private void putIterable(String name2, Iterable l) {
        this._put((byte)4, name2);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        int i2 = 0;
        for (Object obj : l) {
            this._putObjectField(String.valueOf(i2), obj);
            ++i2;
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    private void putMap(String name2, Map m) {
        this._put((byte)3, name2);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        for (Map.Entry entry : m.entrySet()) {
            this._putObjectField(entry.getKey().toString(), entry.getValue());
        }
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    protected void putNull(String name2) {
        this._put((byte)10, name2);
    }

    protected void putUndefined(String name2) {
        this._put((byte)6, name2);
    }

    protected void putTimestamp(String name2, BSONTimestamp ts) {
        this._put((byte)17, name2);
        this._buf.writeInt(ts.getInc());
        this._buf.writeInt(ts.getTime());
    }

    protected void putCodeWScope(String name2, CodeWScope code) {
        this._put((byte)15, name2);
        int temp = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putValueString(code.getCode());
        this.putObject(code.getScope());
        this._buf.writeInt(temp, this._buf.getPosition() - temp);
    }

    protected void putCode(String name2, Code code) {
        this._put((byte)13, name2);
        int temp = this._buf.getPosition();
        this._putValueString(code.getCode());
    }

    protected void putBoolean(String name2, Boolean b) {
        this._put((byte)8, name2);
        this._buf.write(b != false ? 1 : 0);
    }

    protected void putDate(String name2, Date d) {
        this._put((byte)9, name2);
        this._buf.writeLong(d.getTime());
    }

    protected void putNumber(String name2, Number n) {
        if (n instanceof Integer || n instanceof Short || n instanceof Byte || n instanceof AtomicInteger) {
            this._put((byte)16, name2);
            this._buf.writeInt(n.intValue());
        } else if (n instanceof Long || n instanceof AtomicLong) {
            this._put((byte)18, name2);
            this._buf.writeLong(n.longValue());
        } else if (n instanceof Float || n instanceof Double) {
            this._put((byte)1, name2);
            this._buf.writeDouble(n.doubleValue());
        } else {
            throw new IllegalArgumentException("can't serialize " + n.getClass());
        }
    }

    protected void putBinary(String name2, byte[] data2) {
        this.putBinary(name2, 0, data2);
    }

    protected void putBinary(String name2, Binary val) {
        this.putBinary(name2, val.getType(), val.getData());
    }

    private void putBinary(String name2, int type2, byte[] data2) {
        this._put((byte)5, name2);
        int totalLen = data2.length;
        if (type2 == 2) {
            totalLen += 4;
        }
        this._buf.writeInt(totalLen);
        this._buf.write(type2);
        if (type2 == 2) {
            this._buf.writeInt(totalLen - 4);
        }
        int before = this._buf.getPosition();
        this._buf.write(data2);
        int after = this._buf.getPosition();
        MyAsserts.assertEquals((int)(after - before), (int)data2.length);
    }

    protected void putUUID(String name2, UUID val) {
        this._put((byte)5, name2);
        this._buf.writeInt(16);
        this._buf.write(3);
        this._buf.writeLong(val.getMostSignificantBits());
        this._buf.writeLong(val.getLeastSignificantBits());
    }

    protected void putSymbol(String name2, Symbol s2) {
        this._putString(name2, s2.getSymbol(), (byte)14);
    }

    protected void putString(String name2, String s2) {
        this._putString(name2, s2, (byte)2);
    }

    private void _putString(String name2, String s2, byte type2) {
        this._put(type2, name2);
        this._putValueString(s2);
    }

    protected void putObjectId(String name2, ObjectId oid) {
        this._put((byte)7, name2);
        this._buf.writeIntBE(oid._time());
        this._buf.writeIntBE(oid._machine());
        this._buf.writeIntBE(oid._inc());
    }

    private void putPattern(String name2, Pattern p2) {
        this._put((byte)11, name2);
        this._put(p2.pattern());
        this._put(BSON.regexFlags(p2.flags()));
    }

    private void putMinKey(String name2) {
        this._put((byte)-1, name2);
    }

    private void putMaxKey(String name2) {
        this._put((byte)127, name2);
    }

    protected void _put(byte type2, String name2) {
        this._buf.write(type2);
        this._put(name2);
    }

    protected void _putValueString(String s2) {
        int lenPos = this._buf.getPosition();
        this._buf.writeInt(0);
        int strLen = this._put(s2);
        this._buf.writeInt(lenPos, strLen);
    }

    void _reset(Buffer b) {
        b.position(0);
        b.limit(b.capacity());
    }

    protected int _put(String str) {
        int c;
        int len = str.length();
        int total2 = 0;
        for (int i2 = 0; i2 < len; i2 += Character.charCount(c)) {
            c = Character.codePointAt(str, i2);
            if (c < 128) {
                this._buf.write((byte)c);
                ++total2;
                continue;
            }
            if (c < 2048) {
                this._buf.write((byte)(192 + (c >> 6)));
                this._buf.write((byte)(128 + (c & 0x3F)));
                total2 += 2;
                continue;
            }
            if (c < 65536) {
                this._buf.write((byte)(224 + (c >> 12)));
                this._buf.write((byte)(128 + (c >> 6 & 0x3F)));
                this._buf.write((byte)(128 + (c & 0x3F)));
                total2 += 3;
                continue;
            }
            this._buf.write((byte)(240 + (c >> 18)));
            this._buf.write((byte)(128 + (c >> 12 & 0x3F)));
            this._buf.write((byte)(128 + (c >> 6 & 0x3F)));
            this._buf.write((byte)(128 + (c & 0x3F)));
            total2 += 4;
        }
        this._buf.write(0);
        return ++total2;
    }

    public void writeInt(int x) {
        this._buf.writeInt(x);
    }

    public void writeLong(long x) {
        this._buf.writeLong(x);
    }

    public void writeCString(String s2) {
        this._put(s2);
    }
}

