/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bson.BSONException;

public class BSONByteBuffer {
    protected ByteBuffer buf;

    private BSONByteBuffer(ByteBuffer buf) {
        this.buf = buf;
        buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static BSONByteBuffer wrap(byte[] bytes2, int offset2, int length2) {
        return new BSONByteBuffer(ByteBuffer.wrap(bytes2, offset2, length2));
    }

    public static BSONByteBuffer wrap(byte[] bytes2) {
        return new BSONByteBuffer(ByteBuffer.wrap(bytes2));
    }

    public byte get(int i2) {
        return this.buf.get(i2);
    }

    public ByteBuffer get(byte[] bytes2, int offset2, int length2) {
        return this.buf.get(bytes2, offset2, length2);
    }

    public ByteBuffer get(byte[] bytes2) {
        return this.buf.get(bytes2);
    }

    public byte[] array() {
        return this.buf.array();
    }

    public String toString() {
        return this.buf.toString();
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BSONByteBuffer that = (BSONByteBuffer)o;
        return !(this.buf != null ? !this.buf.equals(that.buf) : that.buf != null);
    }

    public int getInt(int i2) {
        return this.getIntLE(i2);
    }

    public int getIntLE(int i2) {
        int x = 0;
        x |= (0xFF & this.buf.get(i2 + 0)) << 0;
        x |= (0xFF & this.buf.get(i2 + 1)) << 8;
        x |= (0xFF & this.buf.get(i2 + 2)) << 16;
        return x |= (0xFF & this.buf.get(i2 + 3)) << 24;
    }

    public int getIntBE(int i2) {
        int x = 0;
        x |= (0xFF & this.buf.get(i2 + 0)) << 24;
        x |= (0xFF & this.buf.get(i2 + 1)) << 16;
        x |= (0xFF & this.buf.get(i2 + 2)) << 8;
        return x |= (0xFF & this.buf.get(i2 + 3)) << 0;
    }

    public long getLong(int i2) {
        return this.buf.getLong(i2);
    }

    public String getCString(int offset2) {
        int end2 = offset2;
        while (this.get(end2) != 0) {
            ++end2;
        }
        int len = end2 - offset2;
        return new String(this.array(), offset2, len);
    }

    public String getUTF8String(int valueOffset) {
        int size2 = this.getInt(valueOffset) - 1;
        try {
            return new String(this.array(), valueOffset + 4, size2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BSONException("Cannot decode string as UTF-8.");
        }
    }

    public Buffer position(int i2) {
        return this.buf.position(i2);
    }

    public Buffer reset() {
        return this.buf.reset();
    }

    public int size() {
        return this.getInt(0);
    }
}

